//  UList.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// UCache.h
// Gaspar Sinai <gsinai@gol.com>
// This template class is for classes that try to share a common resource.
// Tokyo 24 Aug 1997
//

#ifndef __ulist_h__
#define __ulist_h__

#include "UCommon.h"
#include <stdio.h>
#include <iostream.h>
#include <memory.h>


template <class _UListItem>
class UList
{
	int		size;
	int		arraySize;
	_UListItem*	array;
	char**		clientArray;

public:

inline int	getSize () {return size;}

UList (void)
{
	size=0;
	arraySize = 0;
	array = 0;
	clientArray = 0;
}

~UList ()
{
	if (array) delete array;
	if (clientArray) delete clientArray;
}

void
addItem (_UListItem item, char* client)
{
	int		i;
	int		newSize;
	_UListItem*	newArray;
	char**		newClientArray;

	if (size >= arraySize)
	{
		newSize = (arraySize==0) ? 1 : arraySize << 1;
		newArray = new _UListItem[newSize];
		CHECKNULL (newArray);
		newClientArray = new char*[newSize];
		CHECKNULL (newArray);
		memset (newArray, 0, newSize * sizeof (_UListItem));
		memset (newClientArray, 0, newSize * sizeof (char**));
		if (size!=0)
		{
			memcpy (newArray, array, sizeof (_UListItem*) * size);
			memcpy (newClientArray, clientArray, 
				sizeof (char**) * size);
		}
		if (array!=0) delete array;
		if (clientArray!=0) delete clientArray;
		array = newArray;
		clientArray = newClientArray;
		arraySize = newSize;
	}
	for (i=0; i<arraySize; i++)
	{
		if (array[i]==0)
		{
			array[i]=item;
			clientArray[i] = client;
			break;
		}
	}
	size++;
}

int
getIndex (_UListItem item)
{
	int	i;
	for (i=0; i<arraySize; i++)
	{
		if (array[i] == item)
		{
			return i;
		}
	}
	return -1;
}

char*
getClient (_UListItem item)
{
	int	i;
	for (i=0; i<arraySize; i++)
	{
		if (array[i] == item)
		{
			return clientArray[i];
		}
	}
	return 0;
}

_UListItem
getFirst (_UListItem item)
{
	int	i;
	for (i=0; i<arraySize; i++)
	{
		if (array[i] != item && array[i] != 0)
		{
			return array[i];
		}
	}
	return 0;
}

_UListItem
getItem (int itemIndex)
{
	if (itemIndex >= arraySize) return 0;
	return array[itemIndex];
}

void
deleteItem (_UListItem item)
{
	int	i;

	for (i=0; i<arraySize; i++)
	{
		if (array[i] == item)
		{
			array[i] = 0;
			clientArray[i] = 0;
			size--;
			break;
		}
	}
	if (i==arraySize)
	{
		cerr << "warn: list item not found.\n";
	}
}
};

#endif /* __ulist_h__ */
