/**********************************************************************/
/* TERMINAL.C: Recuperation du type de terminal                       */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#if HAVE_STRSTR == 0
#error  This program needs a library containing the 'strstr()' function
#endif

#include <string.h>
#include <ctype.h>
#include "jered.h"

#define TERM_LINUX      1
#define TERM_SM9400     2
#define TERM_AUTRE      3

/**********************************************************************/
int terminal_type(void)
{
        static int first = 1;   /* premier passage */
        static int terminal;    /* valeur a renvoyer */
        char *ptr;
        char tmp[80];

        if (first)
        {
                ptr = (char *)getenv("TERM");
                if (ptr != NULL)
                        strcpy(tmp, ptr);
                else
                        strcpy(tmp, "linux");

                for (ptr = tmp; *ptr; ptr++)
                        *ptr = (char)toupper(*ptr);

                if ((strstr(tmp, "UV") != NULL) || (strstr(tmp, "9400") != NULL))
                        terminal = TERM_SM9400;
                else
                {
                        if (strstr(tmp, "LINUX") != NULL)
                                terminal = TERM_LINUX;
                        else
                                terminal = TERM_AUTRE;
                }
                first = 0;
        }
        return(terminal);
}
/**********************************************************************/
chtype ht(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)194 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)227);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype bt(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)193 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)227);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype gt(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)195 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)230);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype dt(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)180 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)225);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype htd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)203 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)218);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype btd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)202 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)218);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype gtd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)204 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)216);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype dtd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)185 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)217);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype hg(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)218 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)224);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype hm(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)196 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)227);
                case TERM_AUTRE:
                default:
                        return((chtype)'-');
        }
}
/**********************************************************************/
chtype hd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)191 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)228);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype mg(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)179 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)225);
                case TERM_AUTRE:
                default:
                        return((chtype)'|');
        }
}
/**********************************************************************/
chtype mm(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)197 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)'+');
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype md(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)179 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)225);
                case TERM_AUTRE:
                default:
                        return((chtype)'|');
        }
}
/**********************************************************************/
chtype bg(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)192 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)226);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype bm(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)196 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)227);
                case TERM_AUTRE:
                default:
                        return((chtype)'-');
        }
}
/**********************************************************************/
chtype bd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)217 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)229);
                case TERM_AUTRE:
                default:
                        return((chtype)'+');
        }
}
/**********************************************************************/
chtype hgd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)201 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)219);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype hmd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)205 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)218);
                case TERM_AUTRE:
                default:
                        return((chtype)'=');
        }
}
/**********************************************************************/
chtype hdd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)187 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)231);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype mgd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)186 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)217);
                case TERM_AUTRE:
                default:
                        return((chtype)'|');
        }
}
/**********************************************************************/
chtype mmd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)206 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)'*');
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype mdd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)186 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)217);
                case TERM_AUTRE:
                default:
                        return((chtype)'|');
        }
}
/**********************************************************************/
chtype bgd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)200 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)214);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
chtype bmd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)205 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)218);
                case TERM_AUTRE:
                default:
                        return((chtype)'=');
        }
}
/**********************************************************************/
chtype bdd(void)
{
        switch (terminal_type())
        {
                case TERM_LINUX:
                        return((chtype)188 | A_ALTCHARSET);
                case TERM_SM9400:
                        return((chtype)215);
                case TERM_AUTRE:
                default:
                        return((chtype)'*');
        }
}
/**********************************************************************/
