/**********************************************************************/
/* MESSAGES.C: All the messages of JERED are here                     */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include "jered.h"
#include "messages.h"

/* all english messages are here */
static char *english_msg[] =
        {
                "Memory error",
                "Please wait...",
                "Unexpected return to main loop encountered",
                "Autosave:  ",
                "Saving:  ",
                "Error while creating %s",
                "Error while unlinking %s",
                "Error while accessing %s",
                "==== TOP OF FILE ====",
                "==== END OF FILE ====",
                "Error while reading %s",
                "Unknown function",
                "N",
                "Unable to find the macro %s",
                "Error while forking",
                "Type 'exit' to go back to jered\n",
                "Error while exec-ing the shell\n",
                "Error while running the shell",
                "The macro file seems to be corrupted",
                "&1/Cmd &2/Sh &3/Quit &4/Save &5/Find&&Replace &6/Mark &7/Unmark &8/Copy &9/Move &1&0/Remove",
                "ESC: Generate the keys's help file to know which functions are available",
                "Do you really want to remove this block ?",
                "OK",
                "Continue/Replace/All/Stop ? (C/R/A/S)",
                "Press any key...",
                "INSERT ",
                "REPLACE",
                "Col:%3i  Line:%5i/%5i  %c  %s  ",
                "YES|NO",
                "JERED's current Key Mappings:\n",
                "-----------------------------\n\n",
                "Do you really want to quit ?",
                "The macro file was already opened",
                " Find & Replace ",
                "          Find: ",
                "  Replace with: ",
                "   Ignore case: ",
                "Type the string to be Found / Replaced",
                "Type the string to Replace with",
                "Do you want to ignore case ?",
                "Run a command",
                "Type the command to be executed",
                "Save a macro",
                "Type a name for this macro",
                "generate a help file according to current key mappings",
                "shows the internal/external command dialog",
                "does a shell out",
                "quits the current file",
                "saves the current file",
                "shows the Find & Replace dialog box",
                "marks the current line",
                "unmark all the marked lines",
                "copy the marked lines to the line below the current line",
                "deletes all the marked lines",
                "moves the marked lines to the line below the current line",
                "switches to the next file in the list",
                "insert a blank line just below the current line",
                "deletes the current line",
                "moves the cursor up one line",
                "moves the cursor down one line",
                "moves the cursor up one page",
                "moves the cursor down one page",
                "moves the cursor to the beginning of the line",
                "moves the cursor to the end of the line",
                "moves the cursor one position to the left",
                "moves the cursor one position to the right",
                "toggle between insert and replace mode",
                "cuts the line at the cursor's position",
                "moves the cursor to the next tab position",
                "moves the cursor to the previous tab position",
                "deletes the character under the cursor",
                "deletes the character at the left of the cursor",
                "moves the cursor to the previous paragraph",
                "moves the cursor to the next paragraph",
                "moves the cursor to the previous word",
                "moves the cursor to the next word",
                "all the marked lines are converted to upper case",
                "all the marked lines are converted to lower case",
                "the block is aligned to the cursor's column",
                "the block is reformatted",
                "begins/stops a macro recording",
                "plays the current default macro './macro.jem'",
                "executes the man command on the word where the cursor is",
                "executes the info command on the word where the cursor is",
                "puts JERED in the background, to go back type 'fg'",
                "load JERED's help file according to the JEHELP environnement variable",
                "redraws the screen enterely from scratch",
                NULL
        };
        
/* all french messages are here */        
static char *french_msg[] =
        {
                "Erreur de mmoire",
                "Veuillez patienter...",
                "Retour inattendu en boucle principale",
                "Autosauve:  ",
                "Sauvegarder:  ",
                "Erreur en crant %s",
                "Erreur en effacant %s",
                "Erreur en accdant  %s",
                "==== DEBUT DE FICHIER ====",
                "====  FIN DE FICHIER  ====",
                "Erreur en lisant %s",
                "Fonction inconnue",
                "N",
                "Impossible de trouver la macro %s",
                "Erreur durant le fork",
                "Tapez 'exit' pour revenir  jered\n",
                "Erreur en lanant le shell\n",
                "Erreur durant l'excution du shell",
                "Le fichier macro semble tre corrompu",
                "&1/Cmd &2/Sh &3/Quitte &4/Sauve &5/C&&R &6/Marque &7/Demarque &8/Copie &9/Deplace &1&0/Suppr",
                "ESC: Gnrez le fichier d'aide pour connaitre les fonctions disponibles",
                "Voulez-vous vraiment supprimer ce bloc ?",
                "OK",
                "Continue/Remplace/Tout/Stop ? (C/R/T/S)",
                "Pressez une touche...",
                "INSERE  ",
                "REMPLACE",
                "Col:%3i  Ligne:%5i/%5i  %c  %s  ",
                "OUI|NON",
                "Dfinitions actuelles des touches de JERED:\n",
                "-------------------------------------------\n\n",
                "Voulez-vous vraiment quitter ?",
                "Le fichier macro tait dj ouvert",
                " Chercher & Remplacer ",
                "      Chercher: ",
                " Remplacer par: ",
                "    Ignore MAJ: ",
                "Tapez la chaine  chercher / Remplacer",
                "Tapez la chaine de remplacement",
                "Voulez-vous ignorer les diffrences entre MAJUSCULES et minuscules ?",
                "Executer une commande",
                "Tapez la commande  executer",
                "Sauver une macro",
                "Tapez un nom pour cette macro",
                "gnre un fichier d'aide en fonction des dfinitions actuelles des touches",
                "affiche la boite de dialogue de lancement des commandes internes/externes",
                "sort au niveau du shell",
                "quitte le fichier courant",
                "sauve le fichier courant",
                "affiche la boite de dialogue pour Chercher & Remplacer",
                "marque la ligne courante",
                "dmarque toutes les lignes marques",
                "copie les lignes marques vers la ligne suivant la ligne courante",
                "efface toutes les lignes marques",
                "dplace les lignes marques vers la ligne suivant la ligne courante",
                "passe au fichier suivant dans la liste",
                "insere une ligne vide en dessous de la ligne courante",
                "supprime la ligne courante",
                "dplace le curseur vers la ligne prcdente",
                "dplace le curseur vers la ligne suivante",
                "dplace le curseur vers la page prcdente",
                "dplace le curseur vers la page suivante",
                "dplace le curseur au dbut de la ligne",
                "dplace le curseur  la fin de la ligne",
                "dplace le curseur vers la gauche",
                "dplace le curseur vers la droite",
                "bascule entre les modes insertion et remplacement",
                "coupe la ligne  la position du curseur",
                "dplace le curseur vers le prochain taquet de tabulation",
                "dplace le curseur vers le taquet de tabulation prcdent",
                "supprime le caractre qui est sous le curseur",
                "supprime le caractre  la gauche du curseur",
                "dplace le curseur vers le paragraphe prcdent",
                "dplace le curseur vers le paragraphe suivant",
                "dplace le curseur vers le mot prcdent",
                "dplace le curseur vers le mot suivant",
                "convertit toutes les lignes marques en majuscules",
                "convertit toutes les lignes marques en minuscules",
                "aligne le bloc avec la position du curseur",
                "reformatte le bloc",
                "dbute/arrte l'enregistrement d'une macro",
                "excute la macro par dfaut './macro.jem'",
                "excute la commande man sur le mot sur lequel se trouve le curseur",
                "excute la commande info sur le mot sur lequel se trouve le curseur",
                "place JERED en tche de fond, revenez en tapant 'fg'",
                "charge le fichier d'aide de JERED sselon la variable d'environnement JEHELP",
                "redessine compltement l'cran",
                NULL
        };
        
/* all finnish messages are here */        
static char *finnish_msg[] =
        {
                "Muistivirhe",
                "Odota hetki...",
                "Odottamaton paluu plooppiin",
                "Automaattinen tallennus:  ",
                "Tallentaa:  ",
                "Virhe luodessa %s",
                "Virhe poistaessa %s",
                "Virhe saannissa %s",
                "==== TIEDOSTON ALKU ====",
                "==== TIEDOSTON LOPPU ===",
                "Virhe lukiessa %s",
                "Tuntematon toiminto",
                "E", /* Antti asks: what is this ? */
                     /* Jerome answers: it's the default value for Ignore Case: No */
                     /* and I think in Finnish it is: EI. Am I right ? */
                "Tuntematon makro %s",
                "Virhe aliprosessissa",
                "Kirjoita 'exit' palataksesi jerediin\n",
                "Virhe ulkoisen komennon ajossa (exec)\n",
                "Virhe ulkoisen komennon ajossa",
                "Makrotiedosto on korruptoitunut",
                "&1/Aja &2/Ulos &3/Lopeta &4/Tallenna &5/Etsi &6-&7/Rajaa &8/Kopioi &9/Siirr &1&0/Poista",
                "ESC: Lue aputiedosto (help.je) - paina nyt h",
                "Haluatko tosiaan poistaa lohkon?",
                "OK",
                "Jatka/Korvaa/kAikki/Lopeta ? (J/K/A/L)",      /* 28 May 1997: Jerome's modification */
                "Paina jotain nappulaa...",
                "LISYS ",
                "KORVAUS",
                "Sarake: %3i  Rivi:%5i/%5i  %c  %s  ",
                "KYLL|EI",
                "JEREDin nppinmakrot:\n",
                "----------------------\n\n",
                "Haluatko tosiaan lopettaa ?",
                "Makrotiedoto on jo auki",
                " Etsi & Korvaa  ",
                "          Etsi: ",
                "  Korvaa tll: ",
                "   Unohda case: ",
                "Mit etsitn/korvataan",
                "Mik korvataan",
                "Unohdetaanko case ?",
                "Aja",
                "Mit ajetaan",
                "Tallenna makro",
                "Anna makrolle nimi",
                "luo uusi aputiedosto nppinmakroille",
                "nytt ajodialogin",
                "ulkoiseen kehotteeseen",
                "lopettaa tiedoston",
                "tallentaa tiedoston",
                "nytt etsi/korvaa dialogin",
                "rajaa rivin",
                "poistaa kaikki rajaukset",
                "kopioi rajatut rivit",
                "poistaa rajatut rivit",
                "siirt rajatutu rivit",
                "seuraava tiedosto listalta",
                "lis rivin",
                "poistaa rivin",
                "kohdistin yls",
                "kohdistin alas",
                "sivu yls",
                "sivu alas",
                "rivin alkuun",
                "rivin loppuun",
                "merkki vasempaan",
                "merkki oikeaan",
                "vaihtaa lisys/korvaus tilaa",
                "poistaa rivin",
                "seuraava tabulointi",
                "edellinen tabulointi",
                "poista kaikki oikealta",
                "poista kaikki vasemmalta",
                "edellinen kappale",
                "seuraava kappale",
                "edellinen sana",
                "seuraava sana",
                "rajauksessa kaikki kirjaimet suuriksi",
                "rajauksessa kaikki kirjaimet pieniksi",
                "rajaus tasataan kohdistimen sarakkeeseen",
                "rajaus formatoidaan uusiksi",
                "aloittaa/lopettaa makron tallennuksen",
                "ajaa oletusmakron './macro.jem'",
                "nytt manpagen (ohjelma man) sanasta kohdistimen kohdalla",
                "nytt infon (ohjelma) sanasta kohdistimen kohdalla",
                "laittaa JEREDin taustalle, kirjoita 'fg' pstksesi takaisin",
                "load JERED's help file according to the JEHELP environnement variable",
                "redraws the screen enterely from scratch",
                NULL
        };
        
/* all german messages are here */        
static char *german_msg[] =
        {
                "Memory error",
                "Please wait...",
                "Unexpected return to main loop encountered",
                "Autosave:  ",
                "Saving:  ",
                "Error while creating %s",
                "Error while unlinking %s",
                "Error while accessing %s",
                "==== TOP OF FILE ====",
                "==== END OF FILE ====",
                "Error while reading %s",
                "Unknown function",
                "N",
                "Unable to find the macro %s",
                "Error while forking",
                "Type 'exit' to go back to jered\n",
                "Error while exec-ing the shell\n",
                "Error while running the shell",
                "The macro file seems to be corrupted",
                "&1/Cmd &2/Sh &3/Quit &4/Save &5/Find&&Replace &6/Mark &7/Unmark &8/Copy &9/Move &1&0/Remove",
                "ESC: Generate the keys's help file to know which functions are available",
                "Do you really want to remove this block ?",
                "OK",
                "Continue/Replace/All/Stop ? (C/R/A/S)",
                "Press any key...",
                "INSERT ",
                "REPLACE",
                "Col:%3i  Line:%5i/%5i  %c  %s  ",
                "YES|NO",
                "JERED's current Key Mappings:\n",
                "-----------------------------\n\n",
                "Do you really want to quit ?",
                "The macro file was already opened",
                " Find & Replace ",
                "          Find: ",
                "  Replace with: ",
                "   Ignore case: ",
                "Type the string to be Found / Replaced",
                "Type the string to Replace with",
                "Do you want to ignore case ?",
                "Run a command",
                "Type the command to be executed",
                "Save a macro",
                "Type a name for this macro",
                "generate a help file according to current key mappings",
                "shows the internal/external command dialog",
                "does a shell out",
                "quits the current file",
                "saves the current file",
                "shows the Find & Replace dialog box",
                "marks the current line",
                "unmark all the marked lines",
                "copy the marked lines to the line below the current line",
                "deletes all the marked lines",
                "moves the marked lines to the line below the current line",
                "switches to the next file in the list",
                "insert a blank line just below the current line",
                "deletes the current line",
                "moves the cursor up one line",
                "moves the cursor down one line",
                "moves the cursor up one page",
                "moves the cursor down one page",
                "moves the cursor to the beginning of the line",
                "moves the cursor to the end of the line",
                "moves the cursor one position to the left",
                "moves the cursor one position to the right",
                "toggle between insert and replace mode",
                "cuts the line at the cursor's position",
                "moves the cursor to the next tab position",
                "moves the cursor to the previous tab position",
                "deletes the character under the cursor",
                "deletes the character at the left of the cursor",
                "moves the cursor to the previous paragraph",
                "moves the cursor to the next paragraph",
                "moves the cursor to the previous word",
                "moves the cursor to the next word",
                "all the marked lines are converted to upper case",
                "all the marked lines are converted to lower case",
                "the block is aligned to the cursor's column",
                "the block is reformatted",
                "begins/stops a macro recording",
                "plays the current default macro './macro.jem'",
                "executes the man command on the word where the cursor is",
                "executes the info command on the word where the cursor is",
                "puts JERED in the background, to go back type 'fg'",
                "load JERED's help file according to the JEHELP environnement variable",
                "redraws the screen enterely from scratch",
                NULL
        };
        
/* all russian messages are here (in KOI-8 cyrillic encoding)*/
static char *koi8_msg[] =
        {
                " ",
                ", ...",
                "    main loop",
                "  :  ",                
                ":  ",
                "    %s",
                "   unlinking %s",
                "    %s",
                "====    ====",
                "====   ====",
                "    %s",
                " ",
                "",
                "   macro %s",
                "  ",
                " 'exit'    jered\n",
                "     shell\n",
                "     `shell'",
                "   macro file ",
                "&1/Cmd &2/Sh &3/Quit &4/Save &5/Find&&Replace &6/Mark &7/Unmark &8/Copy &9/Move &1&0/Remove",
                "ESC:        (help) .",
                "   ?",
                "OK",
                "/// ? (C/R/A/S)",
                "   ...",
                " ",
                "",
                ":%3i  :%5i/%5i  %c  %s  ",
                "|",
                "   JERED':\n",
                "-----------------------------\n\n",
                "    ?",
                "Macro file   ",
                "      ",
                "                        : ",
                "                   : ",
                "     : ",
                "    / ",
                "    ",
                "   ?",
                " ",
                "   ",
                " macro  ",
                "  macro",
                "      ",
                " /  ",
                " shell out",
                "   ",
                "    ",
                "   `  '",
                "marks the current line",
                "  ",
                "      ",
                "   ",
                "      ",
                "     ",
                "      ",
                "   ",
                "    ",
                "    ",
                "    ",
                "    ",
                "    ",
                "    ",
                "   ",
                "   ",
                "    / ",
                "     ",
                "     tab",
                "     tab",
                "   ",
                "    ",
                "    ",
                "    ",
                "  ",
                "      ",
                "      ",
                "        ",
                "  ",
                "/  macro",
                "  default macro './macro.jem'",
                "  man    ",
                "  info    ",
                " JERED  '' (background),    'fg'",
                "   JERED'   JEHELP",
                "redraws the screen enterely from scratch",
                NULL
        };
        
char **message = NULL;        

/**********************************************************************/
void set_language(int lang)
{
        switch (lang)
        {
                case FRENCH:
                        message = french_msg;
                        break;
                        
                case FINNISH:
                        message = finnish_msg;
                        break;
                        
                case GERMAN:
                        message = german_msg;
                        break;
                        
                case RUSSIAN:        
                        message = koi8_msg;
                        break;
                        
                case ENGLISH:        
                default:
                        message = english_msg;
                        break;
        }
        init_helpbars(message[MSG_HELPBAR], message[MSG_ESCHELPBAR]);        
}
/**********************************************************************/
