;;; emacspeak-w3.el --- Speech enable W3 WWW browser -- includes ACSS Support
;;; $Id: emacspeak-w3.el,v 8.0 1998/05/01 14:15:46 raman Exp $
;;; $Author: raman $ 
;;; Description:  Emacspeak enhancements for W3
;;; Keywords: Emacspeak, W3, WWW
;;{{{  LCD Archive entry: 

;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@adobe.com 
;;; A speech interface to Emacs |
;;; $Date: 1998/05/01 14:15:46 $ |
;;;  $Revision: 8.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:
;;;Copyright (C) 1995, 1996, 1997, 1998   T. V. Raman  Adobe Systems Incorporated
;;; Copyright (c) 1994, 1995 by Digital Equipment Corporation.
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}

(require 'cl)
(declaim  (optimize  (safety 0) (speed 3)))
(require 'emacspeak-fix-interactive)
(require 'emacspeak-sounds)
;;{{{  Introduction:

;;; Commentary:

;;; Ensure that speech support for W3 gets installed and
;;; loaded correctly.
;;; The emacs W3 browser comes with builtin support for
;;; Emacspeak and ACSS

;;; Code:


;;}}}
;;{{{  additional advice

(defadvice url-write-global-history (around emacspeak pre act comp)
  "Silence messages while this function executes"
  (let ((emacspeak-speak-messages nil))
    ad-do-it))

;;}}}
;;{{{ setup

(declaim (special w3-echo-link
                  url-show-status
                  w3-mode-map))

(condition-case nil
    (progn (require 'w3-speak)
           (add-hook 'w3-mode-hook 'w3-speak-mode-hook)
           (setq w3-echo-link 'text)
           (if (locate-library "w3-speak-table")
             (load-library "w3-speak-table")
             (message
              "Please upgrade to W3 4.0.18 for spoken table support"))
           (setq url-show-status nil))
  (error (emacspeak-auditory-icon 'warn-user)
         (message
          "You appear to be using an old version of W3
that is no longer supported by Emacspeak.")))

(add-hook 'w3-mode-hook
                                   (function (lambda ()
                                               (modify-syntax-entry 10 " ")
                                               (define-key w3-mode-map "'"
                                                 'emacspeak-speak-rest-of-buffer)
                                               (define-key w3-mode-map "j"
                                                 'imenu)
                                               (define-key w3-mode-map "\M- "
                                                 'emacspeak-imenu-speak-this-section)
                                               (define-key w3-mode-map "\M-p"
                                                 'emacspeak-imenu-goto-previous-index-position)
                                               (define-key w3-mode-map "\M-n" 'emacspeak-imenu-goto-next-index-position))))


(add-hook                                'w3-load-hook
                                         (function
                                          (lambda ()
                                            (when (locate-library
                                                   "w3-imenu")
                                              (require 'w3-imenu)))))

;;}}}
;;{{{ fix interactive commands

(loop for f in
      '(url-insert-file-contents
w3-hotlist-apropos
w3-open-local
w3-read-html-bookmarks
w3-search-forward
w3-find-file
w3-follow-url-at-point
w3-follow-url-at-point-other-frame
w3-hotlist-append
w3-hotlist-apropos
w3-read-html-bookmarks)
      do
      (emacspeak-fix-interactive-command-if-necessary f ))

;;}}}
;;{{{ fixup images
(declaim (special w3-version))
;;; smart image handling only works in w3 4.0
(when
    (string-match  "4\\.0" w3-version)
; simple heuristic to detect silly bullets and dots
; (by Greg Stark <gsstark@mit.edu>, enriched with regexp)

(defvar w3-min-img-size 16
  "*Image size under which the alt string is replaced by `w3-dummy-img-alt-repl'.
15 is a bit aggressive, 5 pixels would be safer")

(defvar w3-dummy-img-re
  "\\(bullet\\|\\b\\(boule\\|dot\\|pebble[0-9]*[a-z]?[0-9]*\\|pixel\\)\\b\\)"
  "Image name regexp for which the alt string is replaced by `w3-dummy-img-alt-repl'.")

(defvar w3-dummy-img-alt-repl "@"
  "*Dummy img alt replacement")

(declaim (special  w3-auto-image-alt))
(setq w3-auto-image-alt
      (function
       (lambda (s)
         (declare (special width height ))
         (if (or (and (stringp height)
                      (< (string-to-int height) w3-min-img-size))
                 (and (stringp width)
                      (< (string-to-int width) w3-min-img-size))
                 (string-match w3-dummy-img-re s))
             w3-dummy-img-alt-repl
           (concat "[" (file-name-sans-extension s)
                   "]"))))))

;;}}}
(provide 'emacspeak-w3)
;;{{{  emacs local variables 

;;; local variables:
;;; folded-file: t
;;; end: 

;;}}}
