-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
expanded class MEMORY
--
-- Facilities for tuning up the garbage collection, and
-- everything about memory control.
--

feature -- Status Report :

   frozen collecting: BOOLEAN is
	 -- Is garbage collection enabled ?
      do
	 c_inline_c("R=!gc_is_off;");
      end;
   
feature -- Status setting :

   frozen collection_off is
	 -- Disable garbage collection.
      do
	 c_inline_c("gc_is_off=1;");
      end;
   
   frozen collection_on is
	 -- Enable garbage collection.
      do
	 c_inline_c("gc_is_off=0;");
      end;

feature -- Removal :

   dispose is
	 -- Action to be executed just before garbage collection 
	 -- reclaims an object.
      do
	 -- Finalization is not yet implemented.
      end;

   frozen full_collect is
	 -- Force a full collection cycle if garbage collection is
	 -- enabled; do nothing otherwise.
      do
	 c_inline_c("gc_start();");
      end;

feature -- The Guru section (low level memory management) :

   pointer_size: INTEGER is
	 -- The size in number of bytes for a pointer.
      external "SmallEiffel"
      end;

   malloc(size: INTEGER): POINTER is
	 -- Memory allocation of `size' byte.
      require
	 size > 0
      external "C_InlineWithoutCurrent"
      end;

   calloc(number_of_objects, size_of_one: INTEGER): POINTER is
	 -- Memory allocation of `size' byte.
      require
	 number_of_objects > 0;
	 size_of_one >= 1
      external "C_InlineWithoutCurrent"
      end;

   realloc(pointer: POINTER; size: INTEGER): POINTER is
	 -- Memory re-allocation of `size' byte.
      require
	 pointer.is_not_void;
	 size > 0
      external "C_InlineWithoutCurrent"
      end;

   free(pointer: POINTER) is
      obsolete "Replaced by automatic Garbage Collection. %
             %Will be removed in the next release."
      require
	 pointer.is_not_void;
      do
      end;

end -- MEMORY

