/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.80)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                 http://www.loria.fr/SmallEiffel              --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define T8BITS (CHAR_BIT*sizeof(void*))

/* --- Mangling Table Start ---
A*1  T571  R STD_ERROR 571
A 1  T1136 E NATIVE_ARRAY[STRING] 1136
A*1  T474  R BOOLEAN_REF 474
A*1  T101  R CLEAN 101
A 1  T2    E INTEGER 2
A*1  T85   R ECHO 85
A 1  T3    E CHARACTER 3
A*1  T1886 R FIXED_ARRAY[STRING] 1886
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A*1  T7    R STRING 7
A*1  T931  R ARRAY[STRING] 931
A*1  T878  R STD_OUTPUT 878
A 1  T8    E POINTER 8
A 1  T6    E BOOLEAN 6
A*1  T500  R STD_FILE_READ 500
A 1  T673  E FILE_TOOLS 673
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef void*T571;
typedef struct S474 T474;
typedef void*T101;
typedef struct S85 T85;
typedef struct S1886 T1886;
typedef struct S7 T7;
typedef struct S931 T931;
typedef void*T878;
typedef struct S500 T500;
typedef int T673;

/*C Header Pass 2 :*/
typedef T0**T1136;
typedef T3*T9;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
extern T571 M571;
struct S474{T6 _item;};
extern T474 M474;
extern T101 M101;
struct S85{T6 _verbose;};
extern T85 M85;
struct S1886{T1136 _storage;T2 _capacity;T2 _upper;};
extern T1886 M1886;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S931{T1136 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T931 M931;
extern T878 M878;
struct S500{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T500 M500;
extern T673 M673;
T7*se_ms(int c,char*e);
T7*e2s(char*e);
char*s2e(T7*s);
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
void r2append_in(T2 C,T0* a1);
T3 r2digit(T2 C);
T3 r3to_upper(T3 C);
T3 r3to_lower(T3 C);
T6 r3is_letter(T3 C);
T6 r3is_digit(T3 C);
T6 r6_ix_not(T6 C);
void r1136set_all_with(T1136 C,T0* a1,T2 a2);
T6 r1136equal_like(T0* a1,T0* a2);
T2 r1136index_of(T1136 C,T0* a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T2 r9fast_index_of(T9 C,T3 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r7has(T7* C,T3 a1);
T8 r7to_external(T7* C);
void r7set_last(T7* C,T3 a1);
T0* r7twin(T7* C);
void r7to_upper(T7* C);
void r7remove_last(T7* C,T2 a1);
void r7to_lower(T7* C);
T6 r7is_equal(T7* C,T0* a1);
T6 r7has_suffix(T7* C,T0* a1);
T3 r7last(T7* C);
void r7make(T7* C,T2 a1);
void r7append(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
void r7swap(T7* C,T2 a1,T2 a2);
void r7copy(T7* C,T0* a1);
T2 r7index_of(T7* C,T3 a1);
void r1886make(T1886* C,T2 a1);
T0* r931item(T931* C,T2 a1);
T2 r931index_of(T931* C,T0* a1);
void r571put_string(T571* C,T0* a1);
void r101c_files_removing(T101* C,T0* a1);
extern int fBC266system_name;
extern T0*oBC266system_name;
T0* r101system_name(T101* C);
extern T0*oBC266help_file_name;
void r101print_help(T101* C,T0* a1);
extern int fBC266o_suffix;
extern T0*oBC266o_suffix;
T0* r101o_suffix(T101* C);
extern T0*oBC1std_output;
extern T0*oBC266tmp_file_read;
extern int fBC266small_eiffel_directory;
extern T0*oBC266small_eiffel_directory;
T0* r101small_eiffel_directory(T101* C);
extern T673 oBC1file_tools;
T0* r101get_environment_variable(T101* C,T0* a1);
extern T0*oBC1std_error;
extern T0*oBC266system_list;
T6 r101file_exists(T0* a1);
extern int fBC266make_suffix;
extern T0*oBC266make_suffix;
T0* r101make_suffix(T101* C);
T0* r101argument(T2 a1);
void r101add_directory(T101* C,T0* a1,T0* a2);
void r101make(T101* C);
extern T0*oBC266echo;
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r101command_arguments(void);
extern T0*oBC101tmp_string;
extern T0*oBC266tmp_path;
void r85sfr_connect(T85* C,T0* a1,T0* a2);
T6 r85file_exists(T0* a1);
void r85w_put_string(T0* a1);
void r85file_removing(T85* C,T0* a1);
void r85put_string(T85* C,T0* a1);
void r85w_put_character(T3 a1);
extern T0*oBC1070tmp_file_read;
void r878put_string(T878* C,T0* a1);
void r878append_file(T878* C,T0* a1);
void r500read_line(T500* C);
void r500read_line_in(T500* C,T0* a1);
extern T0*oBC869last_string;
T6 r500end_of_input(T500* C);
void r500connect_to(T500* C,T0* a1);
void r500disconnect(T500* C);
void r500read_character(T500* C);
extern T0*oBC673std_fr1;
T6 r673is_readable(T0* a1);
extern T101*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms1_101;
extern T7*ms2_101;
extern T7*ms2_266;
extern T7*ms36_266;
extern T7*ms3_266;
extern T7*ms22_266;
extern T7*ms25_266;
extern T7*ms24_266;
extern T7*ms23_266;
extern T7*ms34_266;
extern T7*ms33_266;
extern T7*ms32_266;
extern T7*ms31_266;
extern T7*ms30_266;
extern T7*ms131_2027;
extern T7*ms3_85;
extern T7*ms17_266;
extern T7*ms132_2027;
extern T7*ms18_266;
extern T7*ms124_2027;
extern T7*ms1_266;
extern T7*ms21_266;
extern T7*ms247_2027;
extern T7*ms19_266;
extern T7*ms20_266;
extern T7*ms10_266;
extern T7*ms12_266;
extern T7*ms13_266;
extern T7*ms14_266;
extern T7*ms15_266;
extern T7*ms16_266;
extern T7*ms11_266;
extern T7*ms1_85;
extern T7*ms2_85;
extern T7*ms3_101;
void se_msi1(void);
void se_msi2(void);
void*se_ma931(int argc,...);

