#|------------------------------------------------------------*-Scheme-*--|
 | File:    test/all.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:42
 | System build:     v0.7.2, 97.12.21
 |
 `------------------------------------------------------------------------|#

#|
   this file should be loaded from the "test/" directory

   % cd test
   % rs all.scm
   ...
   
|#

,(use regex repl compiler)

(define $line-break (string-append (make-string 70 #\=) "\n"))

(define *errors* '())

(define (suite name)
  (display $line-break)
  (format #t "test file: ~s\n" name)
  (let ((envt (copy-top-level-contour *test-envt*)))
    (set-value! (lookup envt '*place*) (list name 'file))
    (handler-case
     (load-into envt (string-append name ".scm"))
     ((<condition> condition: c)
      (format *console-error-port* "ERROR loading ~s\n" name)
      (display-object c *console-error-port*)
      (set! *errors* (cons (list name 'file) *errors*))))))

(define *test-envt* (make-user-initial))
(bind! *test-envt* (& *errors*))

(load-into *test-envt* "expect.scm")

(define match-suite-file
  (reg-expr->proc '(entire (seq (let name (+ (not #\.))) ".scm"))))

(define (find-suite-components)
  (let ((p (open-input-process "/bin/ls")))
    (call-with-list-extending
     (lambda (add)
       (let loop ()
	 (let ((l (read-line p)))
	   (if (eof-object? l)
	       (close-input-port p)
	       (bind ((s e name (match-suite-file l)))
		 (if (and s (not (member name '("all" "expect"))))
		     (add name))
		 (loop)))))))))

(define (run)
  (set! *errors* '())
  (for-each suite (find-suite-components))
  (if (null? *errors*)
      #t
      (begin
	(display $line-break)
	(display "ERROR SUMMARY\n")
	(for-each (lambda (e)
		    (display (reverse e))
		    (newline))
		  *errors*)
	#f)))
