
(define-class <fd-output-port> (<output-port>)
  file-descriptor)

(define-method output-port-write-char ((self <fd-output-port>) 
				       (ch <ascii-char>))
  (fd-write (file-descriptor self)
	    (string ch)
	    0
	    1))

(define-method write-string ((self <fd-output-port>) (str <string>))
  (fd-write (file-descriptor self)
	    str
	    0
	    (string-length str)))


(define-method close-output-port ((self <fd-output-port>))
  ;; we aren't considered to "own" the file-descriptor,
  ;; since we didn't open it
  0)

(define-method flush-output-port ((self <fd-output-port>))
  ;; we don't buffer, either
  0)


(define-class <fd-input-port> (<input-port>)
  file-descriptor
  (input-buffer init-value: #f)
  (input-buffer-cur-offset init-value: 0)
  (input-buffer-filled init-value: 0))

(define-method initialize ((self <fd-input-port>))
  (set-input-buffer! self (make-string 1000))
  self)

(define (fd-input-port-fill! (self <fd-input-port>))
  (let ((n (fd-read (file-descriptor self)
		    (input-buffer self)
		    0
		    (string-length (input-buffer self)))))
    (set-input-buffer-cur-offset! self 0)
    (if (eq? n 0)
	(set-input-buffer! self #f)
	(set-input-buffer-filled! self n))))

(define (fd-input-port-in (self <fd-input-port>) eat?)
  (if (input-buffer self)
      (let ((i (input-buffer-cur-offset self)))
	(if (< i (input-buffer-filled self))
	    (begin
	      (if eat? 
		  (set-input-buffer-cur-offset! self (+ i 1)))
	      (string-ref (input-buffer self) i))
	    (begin
	      (fd-input-port-fill! self)
	      (fd-input-port-in self eat?))))
      $eof-object))

(define-method input-port-read-char ((self <fd-input-port>))
  (fd-input-port-in self #t))

(define-method input-port-peek-char ((self <fd-input-port>))
  (fd-input-port-in self #f))
