/*------------------------------------------------------------------*-C-*-*
 * %Z%1.2  %G% 01:32:20 %W%
 *
 * Purpose:	
 *
 *------------------------------------------------------------------------*
 * Notes:
 *------------------------------------------------------------------------*/

char *__rstore_indirect_sccsid__() { return "%Z%%W% 1.2 %G% 01:32:20"; }

#include "indirect.h"
#include <rscheme/hashmain.h>
#include <rscheme/hashfn.h>

struct VMPageRecord *build_indirect_page( struct RStore *store, 
					  struct PageRef *pr )
{
  access_t a;
  UINT_32  *hdr, size;
  char *data;
  obj itemv;

  /* printf( "Faulting in indirect page: %u\n", pr->base_page_num ); */
  lss_access( store->lss, pr->base_page_num, &a );
  
  hdr = (UINT_32 *)a.addr;
  data = ((char *)a.addr) + 2*sizeof(UINT_32);
  size = a.bytes - 2*sizeof(UINT_32);

  switch (hdr[0])
    {
    case SYMBOL_INDIRECT_PAGE_CONSTRUCTOR:
      itemv = construct_symbols( store, hdr[1], data, size );
      break;
    default:
      fprintf( stderr, "invalid indirect page type: %u\n", hdr[0] );
      abort();
    }
  lss_release( store->lss, &a );
  return setup_indirect_page( store, pr->base_page_num, itemv );
}

  /* this function was ported from the scheme side, because we
     need to be able to call it when demand-loading pages
   */

  /* itemv is a vector of the indirect page items.
     install the entries in the pivot table for later unswizzling
   */

struct VMPageRecord *setup_indirect_page( RStore *store,
 					 UINT_32 page_num,
					 obj itemv )
{
  UINT_32 id, i;
  struct VMPageRecord *vmpr = ALLOC(struct VMPageRecord);

  id = page_num * 64;
  for (i=0; i<SIZEOF_PTR(itemv); i+=SLOT(1))
    {
      obj item;

      item = gvec_read( itemv, i );
      objecttable_insert( store->pivot_table,
			   obj_hash( item ),
			   item,
			   int2fx(id) );
      id++;
    }

  vmpr->mem_address = PTR_TO_DATAPTR(itemv);
  vmpr->ref.base_page_num = page_num;
  vmpr->ref.first = 1;
  vmpr->ref.indirect = 1;
  vmpr->ref.dirty = 0;
  vmpr->ref.loaded = 1;
  vmpr->ref.nth_page = 1;
  install_new_vmpr( store, vmpr );

  /* we need to tuck the itemv away somewhere so the GC doesn't
     come around and release it... we are keeping a pointer 
     into it in the vmpr
  */
  gvec_write( store->owner, 
	      SLOT(2),
	      cons( itemv, gvec_read( store->owner, SLOT(2) ) ) );
  return vmpr;
}
