#include "compress.h"

void init_compressor( struct Compressor *c )
{
    c->ptr = c->temp;
}

void compress_word( struct Compressor *c, UINT_32 word )
{
    *(c->ptr)++ = word >> 24;
    *(c->ptr)++ = word >> 16;
    *(c->ptr)++ = word >> 8;
    *(c->ptr)++ = word >> 0;
}

void compress_obj( struct Compressor *c, obj item )
{
    compress_word( c, VAL(item) );
}

void stop_compressor( struct Compressor *c )
{
}

void close_compressor( struct Compressor *c )
{
}

UINT_32 compressed_size( struct Compressor *c )
{
    return c->ptr - c->temp;
}

void *compressed_data( struct Compressor *c )
{
    return c->temp;
}


void init_decompressor( struct Decompressor *d, void *data, UINT_32 len )
{
    d->ptr = data;
    d->limit = d->ptr + len;
}

UINT_32 decompress_word( struct Decompressor *d )
{
UINT_32 w;

    w = *(d->ptr)++ << 24;
    w += *(d->ptr)++ << 16;
    w += *(d->ptr)++ << 8;
    w += *(d->ptr)++ << 0;
    assert( d->ptr <= d->limit );
    return w;
}

obj decompress_obj( struct Decompressor *d )
{
    return OBJ(decompress_word(d));
}


void close_decompressor( struct Decompressor *d )
{
}

