/*------------------------------------------------------------------*-C-*-*
 * %Z%1.3  %G% 16:41:38 %W%
 *
 * Purpose:	
 *
 *------------------------------------------------------------------------*
 * Notes:
 *------------------------------------------------------------------------*/

char *__rstore_areas_sccsid__() { return "%Z%%W% 1.3 %G% 16:41:38"; }

#include "rstoret.h"
#include "alloc.h"
#include "mmglue.h"
#include <stdio.h>
#include <rscheme/scheme.h>
#include "indirect.h"

rs_bool loading_image = NO; /* hack */

static UINT_32 round_up( UINT_32 n )
{
  return n + ((8-n) & 7);
}

PAllocArea *make_alloc_area( RStore *owner, obj parent )
{
  struct VMPageRecord *vmpr;
  struct PHeapHdr *phh;
  struct FirstPageHdr *fph;
  PAllocArea *aa;

  vmpr = alloc_ppages( owner, owner->next_page, 1 );

  /* the <allocation-area> is allocated in itself */

  fph = (struct FirstPageHdr *)vmpr->mem_address;

  phh = (struct PHeapHdr *)(fph + 1);

  phh->mem_size = round_up( sizeof(PAllocArea) + sizeof(struct PHeapHdr) );
  phh->pstore_flags = 0x12121212;
  phh->size_class = &owner->the_size_class;
  phh->gc_flag_bits = 0xf;
  phh->rs_header.pob_class = alloc_area_class;
  phh->rs_header.pob_size = sizeof(PAllocArea);


  aa = PTR_TO_DATAPTR( PHH_TO_PTR(phh) );

  aa->entry = FALSE_OBJ;
  aa->reserved = FALSE_OBJ;
  aa->allocfn = parea_alloc;

  aa->current_LR.base_page_num = owner->next_page++;
  aa->current_LR.offset = sizeof(struct FirstPageHdr) + phh->mem_size;
  aa->current_LR.nth_page = 1;
  aa->current_LR.first = 1;
  aa->current_LR.indirect = 0;
  aa->current = aa->current_LR.offset + (char *)vmpr->mem_address;

  /* install the 00000000 end-of-page marker */

  ((struct PHeapHdr *)aa->current)->mem_size = 0;

  aa->reserved1 = 0;
  aa->reserved2 = 0;
  aa->owner = owner;
  
  aa->accum_bytes = sizeof( PAllocArea );
  aa->accum_objects = 1;
  aa->accum_pages = 1;

  /* go back and fill in the FirstPageHdr */

  fph->area = aa;
  fph->vmpr = vmpr;
  fph->spare1 = fph->spare2 = 0;

  /* install our parent pointer */

  if (OBJ_ISA_PTR(parent))
    aa->parent_LR = create_LR_first( owner, parent );
  else
    aa->parent_LR = create_immob_LR( parent );

  return aa;
}

struct VMPageRecord *owner_and_vmpr( void *addr, RStore **s )
{
  struct FirstPageHdr *fph = FIRST_PAGE_HDR_OF(addr);

  *s = fph->area->owner;
  return fph->vmpr;
}

static void initFirstPage( struct VMPageRecord *vmpr, PAllocArea *area )
{
  struct FirstPageHdr *fph = vmpr->mem_address;

  fph->area = area;
  fph->vmpr = vmpr;
  fph->spare2 = fph->spare1 = 0;
}

static obj finish_alloc_area( struct PHeapHdr *item )
{
#ifndef NDEBUG
  /* fill the object with a particular bit pattern which, if
   * this is a GVEC, will allow the write barriers to make
   * sure they are being used write (distinguishing the
   * `initializing write' case from other writes)
   */
  
  UINT_32 *mem = (UINT_32 *)(item+1), i;
  
  for (i=(item->rs_header.pob_size)/4 ; i>0;)
    mem[--i] = VAL(DEBUG_TRAP_OBJ);
#endif
  return PHH_TO_PTR(item);
}

obj parea_alloc( AllocArea *base_area, obj the_class, UINT_32 the_size )
{
  PAllocArea  *area = (PAllocArea *)base_area;
  UINT_32 space_req, lo_uses;
  struct PHeapHdr *item;
  RStore *store;

  store = area->owner;

  assert( store ); /* better not get called for a base (transient)
		      allocation! */

  /* figure out how much space we need */

  space_req = round_up( the_size ) + sizeof(struct PHeapHdr);

  if (space_req >= MM_PAGE_SIZE - sizeof(struct FirstPageHdr))
    {
      struct VMPageRecord *vmp;
      struct PHeapHdr *item;

      unsigned n = (space_req + MM_PAGE_SIZE - 1) >> MM_PAGE_BITS;

      /* it's a LARGE OBJECT */
      
      vmp = alloc_ppages( store, store->next_page, n );
      initFirstPage( vmp, area );

      store->next_page += n;

      item = (struct PHeapHdr *)((char *)vmp->mem_address 
				         + sizeof(struct FirstPageHdr));

      item->mem_size = n << MM_PAGE_BITS;
      item->pstore_flags = 0x69699696;
      item->size_class = &store->the_size_class;
      item->gc_flag_bits = 0xF;
      item->rs_header.pob_size = the_size;
      item->rs_header.pob_class = the_class;

      /* update the area stats */

      area->accum_pages += n;
      area->accum_bytes += the_size;
      area->accum_objects++;
      
      return finish_alloc_area(item);
    }

  /* see if we can fit it on the current page */

  if (area->current_LR.offset + space_req > MM_PAGE_SIZE)
    {
      /* doesn't fit, create a new page */
      struct VMPageRecord *vmp;

      vmp = alloc_ppages( store, store->next_page, 1 );
      initFirstPage( vmp, area );

      area->current_LR.base_page_num = store->next_page++;
      area->accum_pages++;
      area->current_LR.offset = sizeof(struct FirstPageHdr);
      item = area->current = (char *)vmp->mem_address + area->current_LR.offset;
#ifndef NDEBUG
      ((struct PHeapHdr *)area->current)->mem_size = 0;
#endif
    }
  else if (area->current)
    {
      item = area->current;
    }
  else
    {
      /* the end page hasn't been used before... resolve it */
      struct VMPageRecord *vmp;
      struct PageRef pr;

      assert( area->current_LR.first && area->current_LR.nth_page == 1 );

      pr.base_page_num = area->current_LR.base_page_num;
      pr.first = 1;
      pr.indirect = 0;
      pr.dirty = 0;
      pr.loaded = 0;
      pr.nth_page = 1;

      vmp = get_vmpr( store, &pr );
      assert( vmp );
      item = area->current = (char *)vmp->mem_address 
	+ area->current_LR.offset;
    }

  assert( ((struct PHeapHdr *)area->current)->mem_size == 0 );

  area->current_LR.offset += space_req;
  area->current = (char *)item + space_req;
  
  /* mark the new end of the page */
  
  if (area->current_LR.offset < MM_PAGE_SIZE)
    {
      ((struct PHeapHdr *)area->current)->mem_size = 0;
    }

  item->mem_size = space_req;
  item->pstore_flags = 0x76766767;
  item->size_class = &store->the_size_class;
  item->gc_flag_bits = 0xF;
  item->rs_header.pob_size = the_size;
  item->rs_header.pob_class = the_class;

  /* update the area stats */

  area->accum_bytes += the_size;
  area->accum_objects++;
  return finish_alloc_area(item);
}
