#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/lowscm/lists.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:37
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  low-scheme
 |
 | Purpose:          general higher-level list operations
 `------------------------------------------------------------------------|#

;; 
;;
;; lists: pairs and #nil

(%strategy ccode
(define (length lst)
  (let loop (((i <fixnum>) 0) 
	     (l lst))
    (if (pair? l)
	(loop (add1 i) (cdr l))
	(if (null? l)
	    i
	    (type-error length 0 lst "not a proper list")))))
)


(define (call-with-list-extending (proc <function>))
  (let ((first #f)
	((last <pair>) (cons 0 '())))
    (set! first last)
    (let ((result (proc (lambda (item)
			  (let (((cell <pair>) (cons item '())))
			    (set-cdr! last cell)
			    (set! last cell)
			    item)))))
      (values (cdr first) result))))

(define (select pred lst)
  (if (pair? lst)
      (let ((first #f)
	    ((last <pair>) (cons 0 '())))
	(set! first last)
	(let-syntax ((add! (syntax-form (item)
			     (let (((cell <pair>) (cons item '())))
			       (set-cdr! last cell)
			       (set! last cell)))))
	  (let loop (((l <pair>) lst))
	    (let ((elem (car l)))
	      (if (pred elem)
		  (add! elem))
	      (if (pair? (cdr l))
		  (loop (cdr l))
		  (cdr first))))))
      '()))

(define (range (n <fixnum>))
  (let loop (((i <fixnum>) n) (r '()))
    (if (eq? i 0)
	r
	(let (((j <fixnum>) (sub1 i)))
	  (loop j (cons j r))))))

(define (list . items)
  items)



(define (reverse lst)
  (if (pair? lst)
      (let loop (((l <pair>) lst) (r '()))
	(if (pair? (cdr l))
	    (loop (cdr l) (cons (car l) r))
	    (if (null? (cdr l))
		(cons (car l) r)
		(error "reverse: not a list: ~s" lst))))
      '()))

(define (reverse! lst)
  (if (pair? lst)
      (let loop ((next lst)
		 (prev '()))
	(if (pair? next)
	    (let ((n (cdr next)))
	      (set-cdr! next prev)
	      (loop n next))
	    prev))
      '()))

(define (delq item list)
  (if (pair? list)
      (let ((r (delq item (cdr list))))
	(if (eq? (car list) item)
	    r
	    (if (eq? r (cdr list))
		list
		(cons (car list) r))))
      list))

(define (delq! item list)
  (let loop ((prev #f) (l list))
    (if (pair? l)
	(let (((l <pair>) l))
	  (if (eq? (car l) item)
	      (if prev
		  (begin
		    (set-cdr! prev (cdr l))
		    (loop prev (cdr l)))
		  (begin
		    (set! list (cdr l))
		    (loop #f (cdr l))))
	      (loop l (cdr l))))
	(if prev
	    list
	    '()))))
