#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/curlybrc.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:40
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          object support for curly-brace text {...}
 `------------------------------------------------------------------------|#

;;

(define-class <curly-braced> (<object>)
  (text type: <string>))

;;

(define-method write-object ((self <curly-braced>) port)
  (output-port-write-char port #\{)
  (write-string port (text self))
  (output-port-write-char port #\}))

(define-method display-object ((self <curly-braced>) port)
  (write-string port (text self)))

(define (string->c-text str)
  (make <curly-braced>
	text: str))
