/*-----------------------------------------------------------------*-C-*---
 * File:    handc/platform/irix/dynlink.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.3
 * File mod date:    1997.11.29 23:10:47
 * System build:     v0.7.2, 97.12.21
 *
 * Purpose:          IRIX dynamic linking interface
 *------------------------------------------------------------------------*/

#include <stdio.h>
#include <dlfcn.h>
#include <rscheme/linktype.h>

void *resolve_link_symbol( void *dlhandle, const char *sym )
{
  void *fct;

  fct = dlsym(dlhandle, sym);
  
  if (fct == NULL) {
    /* couldn't find symbol */
    return NULL;
  } else
    return fct;
  
}

void *dynamic_link_file( const char *path )
{
  void *dlhandle;

  dlhandle = dlopen(path, RTLD_LAZY);

  if (dlhandle == NULL) {
    /* couldn't open DSO */
    return NULL;
  } else
    return dlhandle;

}

void done_resolving( void *dlhandle )
{
  dlclose(dlhandle);
}

void init_dynamic_link( const char *argv0 )
{
}
