

#define INCL_RXSHV	/* Shared variable support */
#define INCL_RXFUNC	/* External functions support */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "rexxsaa.h"

#define DLLNAME "test2"


#define FUNCTION1 Test2Function1
#define FUNCTION2 Test2Function2
#define LOADFUNCS Test2LoadFuncs
#define DROPFUNCS Test2DropFuncs

#define NAME_FUNCTION1 "Test2Function1"
#define NAME_FUNCTION2 "Test2Function2"
#define NAME_LOADFUNCS "Test2LoadFuncs"
#define NAME_DROPFUNCS "Test2DropFuncs"

RexxFunctionHandler Test2Function1;
RexxFunctionHandler Test2Function2;
RexxFunctionHandler Test2LoadFuncs;
RexxFunctionHandler Test2DropFuncs;

/*-----------------------------------------------------------------------------
 * Table entry for a REXX/SQL function.
 *----------------------------------------------------------------------------*/
typedef	struct {
	PSZ	function_name;
	PFN	EntryPoint;
} RexxFunction;

/*-----------------------------------------------------------------------------
 * Table of REXX/SQL Functions. Used to install/de-install functions.
 *----------------------------------------------------------------------------*/
static RexxFunction RexxSqlFunctions[] = {
   {(PSZ)NAME_FUNCTION1,   (PFN)Test2Function1  },
   {(PSZ)NAME_FUNCTION2,   (PFN)Test2Function2  },
   {(PSZ)NAME_DROPFUNCS,   (PFN)Test2DropFuncs  },
   {NULL,NULL}
};

/*-----------------------------------------------------------------------------
 * Uppercases the supplied string.
 *----------------------------------------------------------------------------*/
char *make_upper

#if __STDC__
    (char *str)
#else
    (str)
    char    *str;
#endif

{
 char *save_str=str;
 while(*str)
   {
    if (islower(*str))
       *str = toupper(*str);
    ++str;
   }
 return(save_str);
}

/*-----------------------------------------------------------------------------
 * Allocate memory for a char * based on an RXSTRING
 *----------------------------------------------------------------------------*/
char *AllocString

#if __STDC__
    (char *buf, size_t bufsize)
#else
    (buf, bufsize)
    char    *buf;
    size_t  bufsize;
#endif
{
    char *tempstr=NULL;

    tempstr = (char *)malloc(sizeof(char)*(bufsize+1));
    return tempstr;
}


/*-----------------------------------------------------------------------------
 * Copy a non terminated character array to the nominated buffer (truncate
 * if necessary) and null terminate.
 *----------------------------------------------------------------------------*/
char *MkAsciz

#if __STDC__
    (char *buf, size_t bufsize, char *str, size_t len)
#else
    (buf, bufsize, str, len)
    char    *buf;
    size_t  bufsize;
    char    *str;
    size_t  len;
#endif

{
 bufsize--;	/* Make room for terminating byte */
 if (len > bufsize)
    len = bufsize;
 (void)memcpy(buf, str, len);
 buf[len] = '\0';
 return buf;
}

static void static_show_parameter(ULONG	argc,RXSTRING	argv[],PSZ func_name)
{
 char buf[100];
 if (argc == 0)
   {
    printf("   %s(static): *** No parameters passed ***\n",DLLNAME);
    return;
   }
 memcpy(buf,argv[0].strptr,argv[0].strlength);
 buf[argv[0].strlength] = '\0';
 if (strcmp(func_name,buf) != 0)
    printf("   %s(static): *** Mismatch of parameters: %s is NOT expected: %s ***\n",
               DLLNAME,buf,func_name);
 return;
}

void global_show_parameter(ULONG	argc,RXSTRING	argv[],PSZ func_name)
{
 char buf[100];
 if (argc == 0)
   {
    printf("   %s(global): *** No parameters passed ***\n",DLLNAME);
    return;
   }
 memcpy(buf,argv[0].strptr,argv[0].strlength);
 buf[argv[0].strlength] = '\0';
 if (strcmp(func_name,buf) != 0)
    printf("   %s(global): *** Mismatch of parameters: %s is NOT expected: %s ***\n",
               DLLNAME,buf,func_name);
 return;
}

APIRET APIENTRY FUNCTION1
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
 int i=0;
 for (i=0;i<argc;i++)
   printf("   %s(Test2Function1): Arg: %d <%s>\n",DLLNAME,i,argv[i].strptr);
 static_show_parameter(argc,argv,NAME_FUNCTION1);
 global_show_parameter(argc,argv,NAME_FUNCTION1);
 strcpy(retstr->strptr,"0");
 retstr->strlength = 1;
 return 0L;
}

APIRET APIENTRY FUNCTION2
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
 int i=0;
 for (i=0;i<argc;i++)
   printf("   %s(Test2Function2): Arg: %d <%s>\n",DLLNAME,i,argv[i].strptr);
 static_show_parameter(argc,argv,NAME_FUNCTION2);
 global_show_parameter(argc,argv,NAME_FUNCTION2);
 strcpy(retstr->strptr,"0");
 retstr->strlength = 1;
 return 0L;
}


APIRET APIENTRY DROPFUNCS
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
 int rc=0;
 RexxFunction  *func=NULL;
    
 /* DeRegister all REXX/SQL functions */
 for (func = RexxSqlFunctions; func->function_name; func++)
   {
    rc = RexxDeregisterFunction(func->function_name);
   }
 sprintf(retstr->strptr,"%d",rc);
 retstr->strlength = strlen(retstr->strptr);
 return 0L;
}


/*-----------------------------------------------------------------------------
 * This function is called to initiate REXX/SQL interface.
 *----------------------------------------------------------------------------*/
static int InitRexxSQL

#ifdef __STDC__
    (PSZ progname)
#else
    (progname)
    PSZ progname;
#endif

{
    RexxFunction  *func=NULL;
    ULONG rc=0L;

    /* Register all REXX/SQL functions */
    for (func = RexxSqlFunctions; func->function_name; func++)
      {
        rc = RexxRegisterFunctionDll(func->function_name,DLLNAME,func->function_name);
      }
    return 0;
}

APIRET APIENTRY LOADFUNCS
    (PUCHAR		name,ULONG	argc,RXSTRING	argv[],PSZ		stck,RXSTRING	*retstr)
{
 int rc=0;

 rc = InitRexxSQL(DLLNAME);
 sprintf(retstr->strptr,"%d",rc);
 retstr->strlength = strlen(retstr->strptr);
 return 0L;
}

