#
#   UNIX  (default)
#
PCCTS=/pccts
SET=$(PCCTS)/support/set
PCCTS_H=$(PCCTS)/h
CC=cc
ANTLR=$(PCCTS)/bin/antlr
DLG=$(PCCTS)/bin/dlg
OBJ_EXT=o
OUT_OBJ = -o
CFLAGS= -O -I. -I$(SET) -I$(PCCTS_H) -DUSER_ZZSYN $(COTHER)

OBJ=antlr.o scan.o err.o bits.o build.o fset2.o fset.o gen.o  \
        globals.o hash.o lex.o main.o misc.o set.o pred.o egman.o \
        dumpnode.o

oc:
	#suppress 70
	#suppress 42
	#suppress 41
	#suppress 68
	#suppress 592
	#suppress 593
	#suppress 768
	#suppress 769
	#suppress 65 in main.c
	#load $(CFLAGS) $(LIB) $(SRC)

antlr : $(OBJ) $(SRC)
		$(CC) $(CFLAGS) -o antlr $(OBJ)
		mv antlr $(PCCTS)/bin

# what files does PCCTS generate (both ANTLR and DLG)

PCCTS_GEN=antlr.c scan.c err.c tokens.h mode.h parser.dlg stdpccts.h remap.h

SRC=antlr.c scan.c err.c bits.c build.c fset2.c fset.c gen.c globals.c \
	hash.c lex.c main.c misc.c $(SET)/set.c pred.c egman.c dumpnode.c

#
# Don't worry about the ambiguity messages coming from antlr
# for making antlr.c etc...  [should be 10 of them, I think]
#

antlr.c stdpccts.h parser.dlg tokens.h err.c : antlr.g
	$(ANTLR) -gh antlr.g

antlr.o : antlr.c mode.h tokens.h

scan.o : scan.c mode.h tokens.h

scan.c mode.h: parser.dlg
	$(DLG) -C2 parser.dlg scan.c

set.o : $(SET)/set.c
	$(CC) $(CFLAGS) -c -o set.o $(SET)/set.c


#
# ****** These next targets are common to UNIX and PC world ********
#

#clean up all the intermediate files
clean:
	rm -f *.$(OBJ_EXT) core

#remove everything in clean plus the PCCTS files generated
scrub:
	rm -f $(PCCTS_GEN) *.$(OBJ_EXT) core
