;
; HELP.SCM - the help package for ULTRA II
;
; Source Version: 4.0
; Software Release #92-0043
;
; #include <pact-copyright.h>
;

(define (cm)
   (printf nil " io  - I/O Commands\n")
   (printf nil " ma  - Math Operations Which Do Not Generate a New Curve\n")
   (printf nil " m+  - Math Operations Which Do Generate a New Curve\n")
   (printf nil " ie  - Environmental Inquiry Commands\n")
   (printf nil " ic  - Curve Inquiry Commands\n")
   (printf nil " ce  - Environmental Control Commands\n")
   (printf nil " cp  - Plot Control Commands\n")
   (printf nil " cc  - Curve Control Commands\n")
   (printf nil " ex  - Commands Useful for Writing Extensions\n")
   (printf nil " cn  - Constants\n")
   (printf nil " vr  - Variables\n")
   (printf nil " sy  - Synonyms\n")
   (printf nil "\n To list the members of a group, enter:    help <group-id>")
   (printf nil "\n To list the members of all groups, enter: help all")
   (printf nil "\n For information about a command, enter:   help <command-name>")
   (printf nil "\n For information about a variable, enter:  help <variable-name>")
   (printf nil "\n If you only remember part of a name, try: apropos <substring>\n"))

(define (io)
   (printf nil " I/O Commands:\n")
   (printf nil "   autoload command-log compare hardcopy hc1 ld merge np rd\n")
   (printf nil "   print-menu read-table resume save stop\n"))

(define (ma)
   (printf nil " Math Operations Which Do Not Generate a New Curve:\n")
   (printf nil "   abs absx acos acosx asin asinx atan atanx cos cosh coshx cosx dx dy divx\n")
   (printf nil "   divy error-bar exp expx filter filter-coef j0 j0x j1 j1x jn jnx ln lnx\n")
   (printf nil "   log10 log10x mx my powa powax powr powrx recip recipx sin sinh sinhx sinx\n")
   (printf nil "   smo smooth3 smooth5 sqr sqrt sqrtx sqrx tan tanh tanhx tanx xmax xmin\n")
   (printf nil "   y0 y0x y1 y1x ymax ymin yn ynx\n"))

(define (m+)
   (printf nil " Math Operations Which Do Generate a New Curve:\n")
   (printf nil "   + - * / append-curves average cfft compose convol convolb\n")
   (printf nil "   correl delta derivative diff-measure diffraction edit extract fft fit\n")
   (printf nil "   fitcurve fode gaussian hypot ifft integrate max min normalize span\n")
   (printf nil "   theta thin vs\n"))

(define (ie)
   (printf nil " Environment Inquiry Commands:\n")
   (printf nil "   apropos display file-info help lst menu menui table-attributes\n"))

(define (ic)
   (printf nil " Curve Inquiry Commands:\n")
   (printf nil "   disp get-attributes get-domain get-label get-number-points get-range\n")
   (printf nil "   getx gety stats\n"))

(define (ce)
   (printf nil " Environment Control Commands:\n")
   (printf nil "   close-device end erase kill open-device plots prefix replot screen system\n"))

(define (cp)
   (printf nil " Plot Control Commands:\n")
   (printf nil "   annot autoplot axis data-id domain grid marker-scale mk-pal range\n")
   (printf nil "   rd-pal x-log-scale y-log-scale\n"))

(define (cc)
   (printf nil " Curve Control Commands:\n")
   (printf nil "   color copy copy-curve del dupx hide histogram label line lnstyle lnwidth\n")
   (printf nil "   make-curve make-filter marker random re-color re-id rev scatter select set-id\n")
   (printf nil "   show sort table-curve xindex xmm\n"))

(define (ex)
   (printf nil " Commands Useful for Writing Extensions:\n")
   (printf nil "   autoload* close-device* curve? curve->list file-info* interactive ld* lst*\n")
   (printf nil "   make-curve* menu* open-device* pre prefix* rd* read-table* save* synonym thru\n")
   (printf nil "   ultra-file?\n"))

(define (vr)
   (printf nil " Variables:\n")
   (printf nil "   answer-prompt ascii-output-format axis-grid-style axis-line-style\n")
   (printf nil "   axis-line-width axis-max-major-ticks axis-n-decades axis-number-minor-ticks\n")
   (printf nil "   axis-number-minor-x-ticks axis-number-minor-y-ticks\n")
   (printf nil "   axis-tick-size axis-tick-type axis-type axis-x-format axis-y-format\n")
   (printf nil "   background-color-flag border-width botspace cgm-background-color-flag\n")
   (printf nil "   cgm-flag cgm-name cgm-type console-height console-origin-x console-origin-y\n")
   (printf nil "   console-width console-type default-color default-npts display-name\n")
   (printf nil "   display-title display-type error-bar-cap-size hide-rescale jpeg-flag\n")
   (printf nil "   jpeg-name jpeg-type label-color-flag label-length label-space\n")
   (printf nil "   label-type-size leftspace lines-page n-curves n-curves-read plot-date\n")
   (printf nil "   plot-labels plot-type print-flag print-stats prompt ps-flag ps-name ps-type\n")
   (printf nil "   rightspace simple-append smooth-method squeeze-labels topspace type-face\n")
   (printf nil "   type-size type-style view-height view-origin-x view-origin-y view-width\n")
   (printf nil "   window-height window-height-CGM window-height-PS window-height-JPEG\n")
   (printf nil "   window-origin-x window-origin-x-CGM window-origin-x-PS window-origin-x-JPEG\n")
   (printf nil "   window-origin-y window-origin-y-CGM window-origin-y-PS window-origin-y-JPEG\n")
   (printf nil "   window-width window-width-CGM window-width-PS window-width-JPEG\n"))

(define (cn)
   (printf nil " Constants:\n")
   (printf nil "   cartesian (-1) polar (-2) insel (-3) left (-10) right (-11) center (-12)\n")
   (printf nil "   right-of-axis (9) left-of-axis (10) straddle-axis (11)\n")
   (printf nil "   solid (1) dashed (2) dotted (3) dotdashed (4)\n")
   (printf nil "   plus (0) star (1) triangle (2)\n")
   (printf nil "   all (-9) on (1) off (0) auto (-1) %%pi (3.141592654) %%e (2.718281828)\n")
   (printf nil "   helvetica ('helvetica') times ('times') courier ('courier')\n")                  
   (printf nil "   medium ('medium') italic ('italic')\n")
   (printf nil "   bold ('bold') bold-italic ('bold-italic')\n")
   (printf nil "   black (0) white (1) gray (2) dark-gray (3) blue (4) green (5) cyan (6)\n")
   (printf nil "   red (7) magenta (8) brown (9) dark-blue (10) dark-green (11)\n")
   (printf nil "   dark-cyan (12) dark-red (13) yellow (14) purple (15)\n"))

(define (sy)
   (printf nil " Synonyms:\n")
   (printf nil "   (+ sum) (- dif) (* prod) (/ quot ratio div) (compose comp)\n")
   (printf nil "   (derivative der) (domain dom) (erase era) (integrate int)\n")
   (printf nil "   (hardcopy hc) (kill expunge) (log10x logx) (powr pow) (powrx powx)\n")
   (printf nil "   (range ran) (select # cur) (show unhide) (smooth3 smooth)\n"))

(define-macro (help . args)
   "Usage: help [<group-id> | all | <command-name> | <variable-name>]"
   (printf nil "\n")
   (if (null? args)
       (cm)
       (let* ((arg (car args))
		(evarg (eval arg)))
            (define (isit? x) (eqv? evarg x))
	    (if (isit? all)
		(begin
		   (io) (ma) (m+) (ie) (ic) (ce)
                   (cp) (cc) (ex) (vr) (cn) (sy))
	        (if (or (isit? io) (isit? ma) (isit? m+) (isit? ie)
			(isit? ic) (isit? ce) (isit? cp) (isit? cc)
			(isit? ex) (isit? vr) (isit? cn) (isit? sy)
			(isit? cm))
		    (evarg)
		    (describe* args)))))
   (printf nil "\n"))

