/*
 * SXGRI.C - graphical interface for SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

char
 *SX_pui_file = NULL,
 *SX_GRI_title = NULL,
 *SX_GRI_type_face = NULL,
 *SX_GRI_type_style = NULL;

int
 SX_GRI_type_size = 12;

REAL
 SX_GRI_x  = 0.5,
 SX_GRI_y  = 0.01,
 SX_GRI_dx = 0.0,
 SX_GRI_dy = 0.0;

void
 SC_DECLARE(_SX_end_prog, (void *d, PG_event *ev));

static object
 *SC_DECLARE(SX_iobp, (object *obj)),
 *SC_DECLARE(SX_toggle_gri, (object *toggle)),
 *SC_DECLARE(SX_add_annot, (object *argl));

static void
 SC_DECLARE(_SX_clear_window, (void *d, PG_event *ev)),
 SC_DECLARE(_SX_save_gri, (void *d, PG_event *ev)),
 SC_DECLARE(_SX_set_edit_mode, (void *d, PG_event *ev)),
 SC_DECLARE(_SX_mouse_event_handler, (PG_device *dev, PG_event *ev)),
 SC_DECLARE(_SX_wr_giob, (object *obj, object *strm)),
 SC_DECLARE(_SX_rl_giob, (object *obj));

static PG_interface_object
 *SC_DECLARE(SX_add_text_ann, (PG_device *dev, double xmn, double xmx,
			       double ymn, double ymx, char *s, int clr,
			       int aln, double ang));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* SX_INSTALL_PGS_IOB - install the PGS interface object functions */
 
void SX_install_pgs_iob()
   {
    SS_install("pg-interface-object?",
               "Returns #t if the object is a PGS interface object, and #f otherwise",
               SS_sargs,
               SX_iobp, SS_PR_PROC);

    SS_install("graphical-interface",
               "Procedure: Toggle the graphical interface\n     Usage: graphical-interface [on | off]",
               SS_sargs,
               SX_toggle_gri, SS_PR_PROC);

    SS_install("add-annotation",
               "Procedure: Add textual annotation to the specified device\n     Usage: add-annotation <device> [<text> [<color> [<xmin> <xmax> <ymin> <ymax> [<angle>]]]]",
               SS_nargs,
               SX_add_annot, SS_PR_PROC);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_IOBP - function version of SX_INTERFACE_OBJECTP macro */

static object *SX_iobp(obj)
   object *obj;
   {return(SX_INTERFACE_OBJECTP(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_TOGGLE_GRI - start the graphical interface window */

static object *SX_toggle_gri(toggle)
   object *toggle;
   {int flag;
    char *name;
    static double chi_mn, chi_mx, phi_mn, phi_mx, th_mn, th_mx;
    int sdx, sdy, nc;
    static PG_device *GRI_dev;

    if (PG_console_device == NULL)
       return(SS_f);

    SS_args(toggle,
	    SC_INTEGER_I, &flag,
	    0);

    if (flag)
       {PG_IO_INTERRUPTS(TRUE);

        chi_mn = -180.0;
        chi_mx =  180.0;
        phi_mn = -180.0;
        phi_mx =  180.0;
        th_mn  =    0.0;
        th_mx  =  180.0;

	if (SX_GRI_type_face == NULL)
	   SX_GRI_type_face = SC_strsavef("helvetica",
                              "char*:SX_TOGGLE_GRI:GRI_type_face");

	if (SX_GRI_type_style == NULL)
	   SX_GRI_type_style = SC_strsavef("medium",
                               "char*:SX_TOGGLE_GRI:GRI_type_style");

	if (SX_GRI_title == NULL)
	   SX_GRI_title = SC_strsavef("PDBView Controls",
                          "char*:SX_TOGGLE_GRI:title");

	if (_PG_axis_label_x_format == NULL)
	   _PG_axis_label_x_format = SC_strsavef("%10.2g",
                                     "char*:SX_TOGGLE_GRI:xformat");

	if (_PG_axis_label_y_format == NULL)
	   _PG_axis_label_y_format = SC_strsavef("%10.2g",
                                     "char*:SX_TOGGLE_GRI:yformat");

	if (_PG_axis_type_face == NULL)
	   _PG_axis_type_face = SC_strsavef("helvetica",
                                "char*:SX_TOGGLE_GRI:type_face");

/* connect the I/O functions */
	GRI_dev = PG_make_device("WINDOW", "COLOR", SX_GRI_title);

	PG_query_screen(PG_console_device, &sdx, &sdy, &nc);
        if (SX_GRI_dx == 0.0)
           SX_GRI_dx = 30.0*SX_GRI_type_size/((double) sdx);

        if (SX_GRI_dy == 0.0)
           SX_GRI_dy = 15.0*SX_GRI_type_size/((double) sdy);

	PG_open_device(GRI_dev, SX_GRI_x, SX_GRI_y, SX_GRI_dx, SX_GRI_dy);
	PG_set_viewport(GRI_dev, 0.01, 0.99, 0.1, 0.99);
	PG_set_window(GRI_dev, 0.0, 1.0, 0.0, 1.0);

	PG_set_mouse_down_event_handler(GRI_dev, _SX_mouse_event_handler);

	PG_register_callback("Edit", _SX_set_edit_mode);
	PG_register_callback("End", _SX_end_prog);
	PG_register_callback("Save", _SX_save_gri);
	PG_register_callback("ReDraw", _SX_clear_window);

/* axis controls */
	PG_register_variable("Axis", SC_INTEGER_S,
			     &_PG_axis_on, NULL, NULL);
	PG_register_variable("Grid", SC_INTEGER_S,
			     &SX_grid, NULL, NULL);
	PG_register_variable("Max Major Ticks", SC_INTEGER_S,
			     &_PG_axis_max_major_ticks, NULL, NULL);
	PG_register_variable("# Minor Ticks", SC_INTEGER_S,
			     &_PG_axis_n_minor_ticks, NULL, NULL);
	PG_register_variable("# Decades", SC_DOUBLE_S,
			     &_PG_axis_n_decades, NULL, NULL);
	PG_register_variable("axis_char_angle", SC_DOUBLE_S,
			     &_PG_axis_char_angle, NULL, NULL);
	PG_register_variable("Line Width", SC_DOUBLE_S,
			     &_PG_axis_line_width, NULL, NULL);
	PG_register_variable("Tick Size", SC_DOUBLE_S,
			     &_PG_axis_major_tick_size, NULL, NULL);
	PG_register_variable("X Axis", SC_STRING_S,
			     &_PG_axis_label_x_format, NULL, NULL);
	PG_register_variable("Y Axis", SC_STRING_S,
			     &_PG_axis_label_y_format, NULL, NULL);
	PG_register_variable("Bottom Offset", SC_DOUBLE_S,
			     &SX_botspace, NULL, NULL);
	PG_register_variable("Left Offset", SC_DOUBLE_S,
			     &SX_leftspace, NULL, NULL);
	PG_register_variable("Right Offset", SC_DOUBLE_S,
			     &SX_rightspace, NULL, NULL);
	PG_register_variable("Tops Offset", SC_DOUBLE_S,
			     &SX_topspace, NULL, NULL);

/* font controls */
	PG_register_variable("Type Face", SC_STRING_S,
			     &_PG_axis_type_face, NULL, NULL);
	PG_register_variable("Type Size", SC_INTEGER_S,
			     &SX_plot_type_size, NULL, NULL);
	PG_register_variable("Type Style", SC_STRING_S,
			     &SX_plot_type_style, NULL, NULL);

/* label controls */
	PG_register_variable("Label Color Flag", SC_INTEGER_S,
			     &SX_label_color_flag, NULL, NULL);
	PG_register_variable("Label Length", SC_INTEGER_S,
			     &SX_label_length, NULL, NULL);
	PG_register_variable("Label Type Size", SC_INTEGER_S,
			     &SX_label_type_size, NULL, NULL);
	PG_register_variable("Label Space", SC_DOUBLE_S,
			     &SX_label_space, NULL, NULL);

/* marker controls */
	PG_register_variable("Marker Index", SC_INTEGER_S,
			     &_PG_marker_index, NULL, NULL);
	PG_register_variable("Orientation", SC_DOUBLE_S,
			     &SX_marker_orientation, NULL, NULL);
	PG_register_variable("Marker Scale", SC_DOUBLE_S,
			     &SX_marker_scale, NULL, NULL);

/* math controls */
	PG_register_variable("Smooth Method", SC_STRING_S,
			     &SX_smooth_method, NULL, NULL);

/* mouse location controls */
	PG_register_variable("Mouse", SC_INTEGER_S, 
			     &SX_show_mouse_location, NULL, NULL);
	PG_register_variable("X Location", SC_DOUBLE_S,
			     &SX_show_mouse_location_x, NULL, NULL);
	PG_register_variable("Y Location", SC_DOUBLE_S,
			     &SX_show_mouse_location_y, NULL, NULL);

/* output controls */
	PG_register_variable("PostScript", SC_INTEGER_S,
			     &SX_ps_flag, NULL, NULL);
	PG_register_variable("PS Name", SC_STRING_S,
			     &SX_ps_name, NULL, NULL);
	PG_register_variable("PS Type", SC_STRING_S,
			     &SX_ps_type, NULL, NULL);
	PG_register_variable("CGM", SC_INTEGER_S,
			     &SX_cgm_flag, NULL, NULL);
	PG_register_variable("CGM Name", SC_STRING_S,
			     &SX_cgm_name, NULL, NULL);
	PG_register_variable("CGM Type", SC_STRING_S,
			     &SX_cgm_type, NULL, NULL);

/* rendering controls */
	PG_register_variable("1D->1D", SC_INTEGER_S,
			     &SX_render_1d_1d, NULL, NULL);
	PG_register_variable("2D->1D", SC_INTEGER_S,
			     &SX_render_2d_1d, NULL, NULL);
	PG_register_variable("2D->2D", SC_INTEGER_S,
			     &SX_render_2d_2d, NULL, NULL);
	PG_register_variable("# Contour Levels", SC_INTEGER_S,
			     &_PG_contour_n_levels, NULL, NULL);
	PG_register_variable("Contour Ratio", SC_DOUBLE_S,
			     &_PG_contour_ratio, NULL, NULL);
	PG_register_variable("Chi", SC_DOUBLE_S,
			     &SX_chi, &chi_mn, &chi_mx);
	PG_register_variable("Phi", SC_DOUBLE_S,
			     &SX_phi, &phi_mn, &phi_mx);
	PG_register_variable("Theta", SC_DOUBLE_S,
			     &SX_theta, &th_mn, &th_mx);
	PG_register_variable("Default Color", SC_INTEGER_S,
			     &SX_default_color, NULL, NULL);

/* window controls */
	PG_register_variable("Border Width", SC_INTEGER_S,
			     &SX_border_width, NULL, NULL);
	PG_register_variable("Clear Mode", SC_INTEGER_S,
			     &PG_hl_clear_mode, NULL, NULL);

/* tty output controls */
	PG_register_variable("answer_prompt", SC_STRING_S,
			     SS_ans_prompt, NULL, NULL);
	PG_register_variable("prompt", SC_STRING_S,
			     SS_prompt, NULL, NULL);

	name = SC_search_file(SC_path, SX_pui_file);
	if (name == NULL)
	   {PRINT(stderr, "Can't find %s\n", SX_pui_file);};

	PG_read_interface(GRI_dev, name);

	_SX_clear_window(GRI_dev, NULL);}

    else
       PG_close_device(GRI_dev);

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_CLEAR_WINDOW - clear the screen */

static void _SX_clear_window(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       {PG_clear_window(dev);
        PG_draw_interface_objects(dev);
        PG_update_vs(dev);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_END_PROG - end the program */

void _SX_end_prog(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       {PG_close_device(dev);
        _SX_quit(0);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_SAVE_GRI - save the interface state */

static void _SX_save_gri(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if ((dev != NULL) && (SX_pui_file != NULL))
       PG_write_interface(dev, SX_pui_file);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_SET_EDIT_MODE - turn on editing of interface objects */

static void _SX_set_edit_mode(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       PG_edit_mode = TRUE;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MOUSE_EVENT_HANDLER - handle mouse down events */

static void _SX_mouse_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {PG_interface_object *iob;

    iob = PG_get_object_event(dev, ev);
    if (iob != NULL)
       {PRINT(stdout, "\n%s\n", (char *) iob->obj);}

#ifdef HAVE_WINDOW_DEVICE

    else
       {int wx, wy, btn, mod;

        PG_MOUSE_EVENT_INFO(dev, ev, wx, wy, btn, mod);};

#endif

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_ADD_ANNOT - add an annotation to the given device */

static object *SX_add_annot(argl)
   object *argl;
   {PG_interface_object *iob;
    PG_device *dev;
    int clr, aln;
    REAL xmn, xmx, ymn, ymx, ang;
    char *s;

    dev = NULL;
    s   = NULL;
    clr = 5;
    xmn = 0.0;
    ymn = 0.0;
    xmx = 0.0;
    ymx = 0.0;
    aln = CENTER;
    ang = 0.0;
    SS_args(argl,
            G_DEVICE, &dev,
            SC_STRING_I, &s,
	    SC_INTEGER_I, &clr,
	    SC_REAL_I, &xmn,
	    SC_REAL_I, &xmx,
	    SC_REAL_I, &ymn,
	    SC_REAL_I, &ymx,
	    SC_INTEGER_I, &aln,
	    SC_REAL_I, &ang,
            0);

    if (dev == NULL)
       SS_error("BAD DEVICE - SX_ADD_ANNOT", SS_null);

    if (_SS_length(argl) < 7)
       PG_define_region(dev, NORMC, &xmn, &xmx, &ymn, &ymx);

    if (aln == -10)
       aln = LEFT;
    else if (aln == -11)
       aln = RIGHT;
    else
       aln = CENTER;

    iob = SX_add_text_ann(dev, xmn, xmx, ymn, ymx, s, clr, aln, ang*DEG_RAD);

    return(SX_mk_iob(iob));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_ANNOT_ACTION - define the behavior of events wrt to annotations */

static void SX_annot_action(d, ev)
   byte *d;
   PG_event *ev;
   {

#ifdef HAVE_WINDOW_DEVICE

    int type;

    if (ev != NULL)
       {type = PG_EVENT_TYPE(*ev);

/* mouse events are handled first since PG_handle_key_press also looks for
 * some mouse events
 */
	if (type == MOUSE_DOWN_EVENT)
           {PG_device *dev;
	    PG_interface_object *iob;
	    int ix, iy, btn, mod;

	    iob = (PG_interface_object *) d;
	    dev = iob->device;

	    PG_query_pointer(dev, &ix, &iy, &btn, &mod);
	    switch (btn)
	       {case MOUSE_LEFT :
		     PG_move_object(iob, 0, 10000, 0, 10000, TRUE);
                     break;

		case MOUSE_RIGHT :
		     PG_set_color_fill(dev, dev->BLACK, TRUE);
		     PG_fill_curve(dev, iob->curve);
		     PG_set_color_line(dev, dev->BLACK, FALSE);
		     PG_draw_curve(dev, iob->curve, FALSE);
		     PG_set_color_line(dev, dev->WHITE, TRUE);

                     SX_rem_iob(iob, TRUE);

		     break;};

	    PG_update_vs(dev);}

        else if (type == KEY_DOWN_EVENT)
	   PG_handle_key_press(d, ev);};

#endif

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_ADD_TEXT_ANN - register a TEXT interface object with the device
 *                 - this is intended for annotations of plots
 */

static PG_interface_object *SX_add_text_ann(dev, xmn, xmx, ymn, ymx,
					    s, clr, align, ang)
   PG_device *dev;
   double xmn, xmx, ymn, ymx;
   char *s;
   int clr, align;
   double ang;
   {PG_interface_object *iob;
    PG_curve *crv;
    PG_text_box *b;
    double xo, yo;
    int flags[3];
    static int first = TRUE;

    if (first)
       {PG_register_callback("SX_annot_action", SX_annot_action);
        first = FALSE;};

/* make them visible, selectable, and active */
    flags[0] = TRUE;
    flags[1] = TRUE;
    flags[2] = TRUE;

    if (s == NULL)
       s = SC_strsavef("                        ",
           "char*:SX_ADD_TEXT_ANN:blankstring");

    xo  = xmn;
    yo  = ymn;
    crv = PG_make_box_curve(dev, NORMC, xo, yo, xmn, xmx, ymn, ymx);

/* Make sure color is visible */
    clr = _PG_trans_color(dev, clr);

    iob = PG_make_interface_object(dev, s, PG_TEXT_OBJECT_S, NULL, align, ang,
				   crv, flags, clr, dev->BLACK,
                                   NULL, NULL, "SX_annot_action",
                                   NULL, NULL);

    PG_register_interface_object(dev, iob);

    b = (PG_text_box *) iob->obj;
    b->border = 0.0;

    PG_draw_interface_object(iob);
    PG_update_vs(dev);

    return(iob);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_REM_IOB - remove an interface object from the device
 *            - if FLAG is TRUE remove the objects children as well
 */

void SX_rem_iob(iob, flag)
   PG_interface_object *iob;
   int flag;
   {int i, niobs;
    PG_interface_object **iobs;
    PG_device *dev;

    dev   = iob->device;
    iobs  = dev->interface_objects;
    niobs = dev->n_interface_objects;

    for (i = 0; i < niobs; i++)
        {if (iob == iobs[i])
            {niobs--;
             iobs[i] = iobs[niobs];
             _PG_rl_interface_object(iob, flag);
             break;};};

    dev->n_interface_objects = niobs;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MK_IOB - encapsulate a PG_interface_object as an object */

object *SX_mk_iob(iob)
   PG_interface_object *iob;
   {object *op;

    op = SS_mk_object(iob, G_INTERFACE_OBJECT, SELF_EV, iob->name);
    op->print   = _SX_wr_giob;
    op->release = _SX_rl_giob;

    SC_mark(iob, 1);

    return(op);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_WR_GIOB - print a g_interface_object */

static void _SX_wr_giob(obj, strm)
   object *obj, *strm;
   {PRINT(SS_OUTSTREAM(strm), "<INTERFACE_OBJECT|%s>",
                              INTERFACE_OBJECT_NAME(obj));

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_RL_GIOB - gc a interface_object */

static void _SX_rl_giob(obj)
   object *obj;
   {int rc;
    PG_interface_object *iob;

    iob = INTERFACE_OBJECT(obj);
    rc  = SC_mark(iob, -1);
    if (rc < 1)
       SX_rem_iob(iob, TRUE);

    SS_rl_object(obj);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
