/*
 * SHPRM3.C - Scheme primitive routines
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

/*--------------------------------------------------------------------------*/

/*                        LIST PRIMITIVES                                   */

/*--------------------------------------------------------------------------*/

/* _SS_ENDCONS - C version of endcons */

object *_SS_endcons(list, obj)
   object *list, *obj;
   {object *op, *mlist;

    mlist = list;
    if (SS_nullobjp(list))
       return(SS_mk_cons(obj, SS_null));
    if (!SS_consp(list))
       return(SS_mk_cons(list, SS_mk_cons(obj, SS_null)));

    else
       {op = SS_mk_cons(obj, SS_null);
        while (SS_consp(mlist = SS_cdr(mlist)));
        _SS_setcdr(mlist, op);
        return(list);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CONS - gets the car and cadr of the arg list
 *         - puts them into a new object, and
 *         - returns a pointer to it
 *         - this is the Scheme version of cons
 */

object *SS_cons(argl)
   object *argl;
   {Register object *x1,  *x2;

    x1 = SS_car(argl);
    x2 = SS_cadr(argl);
    return(SS_mk_cons(x1, x2));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_SETCAR - set-car! at C level
 *            - return value is the new car
 */

object *_SS_setcar(pair, car)
   object *pair, *car;
   {Register object *oldcar;

    oldcar = SS_car(pair);
    SS_MARK(car);
    SS_CAR_MACRO(pair) = car;
    SS_GC(oldcar);

    return(car);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_SETCDR - set-cdr! at C level
 *            - return value is the new cdr
 */

object *_SS_setcdr(pair, cdr)
   object *pair, *cdr;
   {Register object *oldcdr;

    oldcdr = SS_cdr(pair);
    SS_MARK(cdr);
    SS_CDR_MACRO(pair) = cdr;
    SS_GC(oldcdr);

    return(cdr);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_SETCAR - set-car! at Scheme level */

object *SS_setcar(argl)
   object *argl;
   {return(_SS_setcar(SS_car(argl), SS_cadr(argl)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_SETCDR - set-cdr! at Scheme level */

object *SS_setcdr(argl)
   object *argl;
   {return(_SS_setcdr(SS_car(argl), SS_cadr(argl)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CAR - return a pointer to the car of the object given */

object *SS_car(obj)
   object *obj;
   {if (!SS_consp(obj))
       SS_error("CAN'T TAKE CAR OF ATOM - CAR", obj);
    return(SS_CAR_MACRO(obj));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDR - return a pointer to the cdr of the object given */

object *SS_cdr(obj)
   object *obj;
   {if (!SS_consp(obj))
       SS_error("CAN'T TAKE CDR OF ATOM - CAR", obj);
    return(SS_CDR_MACRO(obj));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CAAR - return a pointer to the caar of the object given */

object *SS_caar(obj)
   object *obj;
   {return(SS_car(SS_car(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CADR - return a pointer to the cadr of the object given */

object *SS_cadr(obj)
   object *obj;
   {return(SS_car(SS_cdr(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDAR - return a pointer to the cdar of the object given */

object *SS_cdar(obj)
   object *obj;
   {return(SS_cdr(SS_car(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDDR - return a pointer to the cddr of the object given */

object *SS_cddr(obj)
   object *obj;
   {return(SS_cdr(SS_cdr(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CAAAR - return a pointer to the caaar of the object given */

object *SS_caaar(obj)
   object *obj;
   {return(SS_car(SS_car(SS_car(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CAADR - return a pointer to the caadr of the object given */

object *SS_caadr(obj)
   object *obj;
   {return(SS_car(SS_car(SS_cdr(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CADAR - return a pointer to the cadar of the object given */

object *SS_cadar(obj)
   object *obj;
   {return(SS_car(SS_cdr(SS_car(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CADDR - return a pointer to the caddr of the object given */

object *SS_caddr(obj)
   object *obj;
   {return(SS_car(SS_cdr(SS_cdr(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDAAR - return a pointer to the cdaar of the object given */

object *SS_cdaar(obj)
   object *obj;
   {return(SS_cdr(SS_car(SS_car(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDADR - return a pointer to the cdadr of the object given */

object *SS_cdadr(obj)
   object *obj;
   {return(SS_cdr(SS_car(SS_cdr(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDDAR - return a pointer to the cddar of the object given */

object *SS_cddar(obj)
   object *obj;
   {return(SS_cdr(SS_cdr(SS_car(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CDDDR - return a pointer to the cdddr of the object given */

object *SS_cdddr(obj)
   object *obj;
   {return(SS_cdr(SS_cdr(SS_cdr(obj))));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LST_REF - return the nth element of the list */

object *SS_lst_ref(argl)
   object *argl;
   {object *lst;

    lst = SS_lst_tail(argl);
    return(SS_nullobjp(lst) ? SS_null : SS_car(lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LST_TAIL - return the tail of the list omitting the first n elements */

object *SS_lst_tail(argl)
   object *argl;
   {object *lst;
    int n;

    SS_args(argl,
	    SS_OBJECT_I, &lst,
	    SC_INTEGER_I, &n,
            0);

    return(_SS_lst_tail(lst, n));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_LST_TAIL - return the tail of the list omitting the first n elements */

object *_SS_lst_tail(lst, n)
   object *lst;
   int n;
   {int i;

    if (!SS_nullobjp(lst))
       {if ((0 <= n) && (n < _SS_length(lst)))
           {for (i = 0; i < n; i++, lst = SS_cdr(lst));
            return(lst);};};

    return(SS_null);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LAST - return a pointer to the last element of a list */

object *SS_last(obj)
   object *obj;
   {Register object *t, *lst;

    t = obj;
    for (lst = obj; SS_consp(lst); lst = SS_cdr(lst))
        t = lst;

    if (!SS_consp(t))
       return(t);
    else if (SS_nullobjp(lst = SS_cdr(t)))
       return(SS_car(t));
    else
       return(lst);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_REVERSE - reverse the list in place and return it */

object *SS_reverse(obj)
   object *obj;
   {Register object *ths, *nxt, *prv;

    if (SS_nullobjp(obj))
       return(obj);

    if (!SS_consp(obj))
       SS_error("BAD LIST TO REVERSE", obj);

    for (ths = SS_null, nxt = obj; SS_consp(nxt); )
         {prv = ths;
          ths = nxt;
          nxt = SS_cdr(nxt);
          SS_CDR_MACRO(ths) = prv;
          SS_MARK(prv);
          SC_mark(nxt, -1);};

    return(ths);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_APPEND - append two lists together and return a pointer
 *           - to the first one
 *           - Scheme version of append
 */

object *SS_append(obj)
   object *obj;
   {return(_SS_append(SS_car(obj), SS_cadr(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_APPEND - append two lists together and return a pointer
 *            - to the first one
 *            - C version of append
 */

object *_SS_append(lst1, lst2)
   object *lst1, *lst2;
   {Register object *frst, *lst, *nxt, *cr;

    if (!SS_consp(lst2) && !SS_nullobjp(lst2))
       SS_error("BAD SECOND LIST - _SS_APPEND", lst2);

    if (SS_nullobjp(lst1))
       return(lst2);

    else if (SS_consp(lst1))
       {frst = SS_null;
	cr   = SS_null;
	SS_Assign(cr, lst1);
        while (SS_consp(cr))
           {nxt = SS_car(cr);
            SS_end_cons(frst, lst, nxt);
            SS_Assign(cr, SS_cdr(cr));};

        _SS_setcdr(lst, lst2);

        return(frst);}

    else
       SS_error("BAD FIRST LIST - _SS_APPEND", lst1);

    return(SS_null);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_LENGTH - length primitive in Scheme */

object *SS_length(obj)
   object *obj;
   {obj = SS_car(obj);
    if (!SS_consp(obj))
       SS_error("OBJECT NOT A LIST - LENGTH", obj);

    return(SS_mk_integer((long) _SS_length(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_LENGTH - C usable version of length function in Scheme */

int _SS_length(obj)
   object *obj;
   {Register int i;

    for (i = 0; SS_consp(obj); i++)
        obj = SS_cdr(obj);

    return(i);}

/*--------------------------------------------------------------------------*/

/*                            PREDICATES                                    */

/*--------------------------------------------------------------------------*/

/* _SS_NUMBERP - number? predicate in C */

int _SS_numberp(obj)
   object *obj;
   {return((SS_integerp(obj) || SS_floatp(obj)));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_NUMBERP - number? predicate in Scheme */

object *SS_numberp(obj)
   object *obj;
   {return((SS_integerp(obj) || SS_floatp(obj)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INTP - function version of SS_integerp macro */

object *SS_intp(obj)
   object *obj;
   {return(SS_integerp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_REALP - function version of SS_floatp macro */

object *SS_realp(obj)
   object *obj;
   {return(SS_floatp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STRP - function version of SS_stringp macro */

object *SS_strp(obj)
   object *obj;
   {return(SS_stringp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_VARP - function version of SS_variablep macro */

object *SS_varp(obj)
   object *obj;
   {return(SS_variablep(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_BOOLP - function version of SS_booleanp macro */

object *SS_boolp(obj)
   object *obj;
   {return(SS_booleanp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PAIR - function version of SS_consp macro */

object *SS_pair(obj)
   object *obj;
   {return(SS_consp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PROCP - function version of SS_procedurep macro */

object *SS_procp(obj)
   object *obj;
   {return(SS_procedurep(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_FILEP - file? predicate in Scheme */

object *SS_filep(argl)
   object *argl;
   {return(_SS_filep(argl, NULL) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ASCII_FILEP - ascii-file? predicate in Scheme */

object *SS_ascii_filep(argl)
   object *argl;
   {return(_SS_filep(argl, "ascii") ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_FILEP - worker routine for file? and ascii-file? predicates */

int _SS_filep(argl, dtype)
   object *argl;
   char *dtype;
   {char *name, *mode, *type, *scope;
    char **list;
    int ret;

    name  = NULL;
    mode  = NULL;
    type  = dtype;
    scope = NULL;

    SS_args(argl,
	    SC_STRING_I, &name,
	    SC_STRING_I, &mode,
	    SC_STRING_I, &type,
	    SC_STRING_I, &scope,
	    0);

    if (mode != NULL)
       if (strcmp(mode, "nil") == 0)
	  SFREE(mode);

    if (type != NULL)
       if (strcmp(type, "nil") == 0)
	  SFREE(type);

    if (scope == NULL)
       scope = SC_strsavef("local", "char*:_SS_FILEP:local");

    if (strcmp(scope, "local") == 0)
       list = NULL;
    else
       list = SC_path;

    ret = (_SC_search_file(list, name, mode, type) != NULL);

    SFREE(name);
    SFREE(mode);
    if (type != dtype)
       SFREE(type);
    SFREE(scope);

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_EOFP - function version of SS_eofobjp macro */

object *SS_eofp(obj)
   object *obj;
   {return(SS_eofobjp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_NULLP - null? for Scheme */

object *SS_nullp(obj)
   object *obj;
   {return(SS_nullobjp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_EQV - eqv? at C level */

int _SS_eqv(o1, o2)
   object *o1, *o2;
   {int ityp;

    if (SC_arrtype(o1, -1) != SC_arrtype(o2, -1))
       return(FALSE);

    ityp = SC_arrtype(o1, -1);
    switch (ityp)
       {case SC_INTEGER_I :
	     return(SS_INTEGER_VALUE(o1) == SS_INTEGER_VALUE(o2));

        case SC_FLOAT_I :
	     return(SS_FLOAT_VALUE(o1) == SS_FLOAT_VALUE(o2));

        case SC_STRING_I :
	     return(strcmp(SS_STRING_TEXT(o1), SS_STRING_TEXT(o2)) == 0);

        case CHAR_OBJ :
	     return(SS_CHARACTER_VALUE(o1) == SS_CHARACTER_VALUE(o2));

        case VARIABLE :
	     return(strcmp(SS_VARIABLE_NAME(o1), SS_VARIABLE_NAME(o2)) == 0);

        case BOOLEAN :
	     return(SS_BOOLEAN_VALUE(o1) == SS_BOOLEAN_VALUE(o2));

        case PROC_OBJ :
	     return(SS_PROCEDURE_PROC(o1) == SS_PROCEDURE_PROC(o2));

        default :
             return(o1->val == o2->val);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_EQUAL - equal? at C level */

int _SS_equal(o1, o2)
   object *o1, *o2;
   {

    if (SC_arrtype(o1, -1) != SC_arrtype(o2, -1))
       return(FALSE);

    if (SS_consp(o1))
       {if (_SS_length(o1) != _SS_length(o2))
           return(FALSE);
        while (TRUE)
           {if (!SS_consp(o1))
               return(_SS_eqv(o1, o2));

            if (!_SS_equal(SS_car(o1), SS_car(o2)))
               return(FALSE);

            o1 = SS_cdr(o1);
            o2 = SS_cdr(o2);};}

    else if (SS_procedurep(o1))
       {if (((SS_PROCEDURE_TYPE(o1) == SS_PROC) &&
             (SS_PROCEDURE_TYPE(o2) == SS_PROC)) ||
            ((SS_PROCEDURE_TYPE(o1) == SS_MACRO) &&
             (SS_PROCEDURE_TYPE(o2) == SS_MACRO)))
           return(_SS_equal(SS_proc_body(o1), SS_proc_body(o2)));

        else
          return(FALSE);}

    else
       return(_SS_eqv(o1, o2));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_EQ - eq? in at C level */

int _SS_eq(o1, o2)
   object *o1, *o2;
   {return(o1->val == o2->val);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_EQ - eq? in Scheme */

object *SS_eq(obj)
   object *obj;
   {return(_SS_eq(SS_car(obj), SS_cadr(obj)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_EQV - eqv? in Scheme */

object *SS_eqv(obj)
   object *obj;
   {return(_SS_eqv(SS_car(obj), SS_cadr(obj)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_EQUAL - equal in Scheme */

object *SS_equal(obj)
   object *obj;
   {return(_SS_equal(SS_car(obj), SS_cadr(obj)) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_MEMP - C level handler for memq, memv, and member */

object *_SS_memp(pred, obj, lst)
   int (*pred)();
   object *obj, *lst;
   {Register object *tmp;

    while (TRUE)
       {if (!SS_consp(lst))
           break;

        tmp = SS_car(lst);
        if ((*pred)(obj, tmp))
           return(lst);

        lst = SS_cdr(lst);};

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_MEMQ - Scheme version of memq */

object *SS_memq(argl)
   object *argl;
   {Register object *obj, *lst;

    obj = SS_car(argl);
    lst = SS_cadr(argl);

    return(_SS_memp(_SS_eq, obj, lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_MEMV - Scheme version of memv */

object *SS_memv(argl)
   object *argl;
   {Register object *obj, *lst;

    obj = SS_car(argl);
    lst = SS_cadr(argl);

    return(_SS_memp(_SS_eqv, obj, lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_MEMBER - Scheme version of member */

object *SS_member(argl)
   object *argl;
   {Register object *obj, *lst;

    obj = SS_car(argl);
    lst = SS_cadr(argl);

    return(_SS_memp(_SS_equal, obj, lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_ASSP - C level handler for assq, assv, and assoc */

object *_SS_assp(pred, obj, lst)
   int (*pred)();
   object *obj, *lst;
   {Register object *tmp;

    for ( ; SS_consp(lst); lst = SS_cdr(lst))
        {tmp = SS_car(lst);
         if ((*pred)(obj, SS_car(tmp)))
            return(tmp);};

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ASSQ - Scheme version of assq */

object *SS_assq(argl)
   object *argl;
   {Register object *obj, *lst;

    obj = SS_car(argl);
    lst = SS_cadr(argl);

    return(_SS_assp(_SS_eq, obj, lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ASSV - Scheme version of assv */

object *SS_assv(argl)
   object *argl;
   {Register object *obj, *lst;

    obj = SS_car(argl);
    lst = SS_cadr(argl);

    return(_SS_assp(_SS_eqv, obj, lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ASSOC - Scheme version of assoc */

object *SS_assoc(argl)
   object *argl;
   {Register object *obj, *lst;

    obj = SS_car(argl);
    lst = SS_cadr(argl);

    return(_SS_assp(_SS_equal, obj, lst));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
