/*
 * PCNLTSS.C - NLTSS operating system routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "ppc.h"
#include "baselb.h"

#define NO_CONTROLLEE_TO_SEND   3
#define NO_CONTROLLEE_ATTACHED  2
#define RECEIVE_STATE           6
#define MESSAGE_RECEIVED        0

char
 **argv_cray;

static int
 _PC_nltss_release(PROCESS *pp),
 _PC_nltss_in_ready(PROCESS *pp),
 _PC_nltss_close(PROCESS *pp),
 _PC_nltss_status(PROCESS *pp),
 _PC_nltss_flush(PROCESS *pp),
 _PC_nltss_gets(char *bf, int len, PROCESS *pp),
 _PC_nltss_printf(PROCESS *pp, char *buffer);

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* FORK - fake a UNIX fork under NLTSS
 *      - return 1 if successful
 *      - and -1 otherwise
 */

fork()
   {int  flag, len, i;
    char bf[MAXLINE];
    static id = 2;

    PC_ERR_TRAP(-1);

    flag = IZNITIAL(argv_cray[0], &Zero_I, &Zero_I);
    if (flag != 0)
       PC_error("COULDN'T INITIALIZE PROCESS (%d) - FORK", flag);

/* build the message in bf */
    strcpy(bf, argv_cray[1]);
    for (i = 2; argv_cray[i] != '\0'; i++)
        {strcat(bf, " ");
         strcat(bf, argv_cray[i]);};

    len  = strlen(bf);
    flag = IZSNDME(bf, &len, &Zero_I);
    if (flag != 0)
       PC_error("COULDN'T SEND MESSAGE TO PROCESS (%d) - FORK", flag);

    return(id++);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_MK_PROCESS - initialize and return a PROCESS */

PROCESS *PC_mk_process(argv, mode, type)
   char **argv, *mode;
   int type;
   {PROCESS *pp;

    argv_cray = argv;

    pp = FMAKE(PROCESS, "PC_MK_PROCESS:pp");

    pp->in_ring  = FMAKE_N(unsigned char, SIZE_BUF,
                   "PC_MK_PROCESS:in_ring");
    pp->ib_in    = 0;
    pp->ob_in    = 0;

    pp->type     = PC_LOCAL;
    pp->rcpu     = -1;
    pp->acpu     = -1;

    pp->line_mode = FALSE;
    pp->line_sep  = 0x1f;
    pp->blocking  = TRUE;

    if (mode[1] == 'b')
       {pp->vif = PD_open_vif(argv[0]);
        pp->vif->stream = (FILE *) pp;}

    else
       pp->vif = NULL;

/* assign procedures to service this process */
    pp->release    = _PC_nltss_release;
    pp->exec       = NULL;
    pp->close      = _PC_nltss_close;
    pp->statusp    = _PC_nltss_status;
    pp->flush      = _PC_nltss_flush;
    pp->read       = _PC_bin_read;
    pp->write      = _PC_bin_write;
    pp->printf     = _PC_nltss_printf;
    pp->gets       = _PC_nltss_gets;
    pp->in_ready   = _PC_nltss_in_ready;
    pp->setup      = NULL;

    if (type == PC_PARENT)
       _PC_manage_process(pp);

    return(pp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_RELEASE - close the file descriptors and release the PROCESS */

static int _PC_nltss_release(pp)
   PROCESS *pp;
   {if (pp == NULL)
       return(FALSE);

    SFREE(pp->in_ring);
    SFREE(pp);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_STATUS - return the status of the process */

static int _PC_nltss_status(pp)
   PROCESS *pp;
   {if (pp == NULL)
       return(EXITED);
    else
       return(pp->status & ~CHANGED);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_FGETS - get a string from the given file
 *           - if none are available or there is an return NULL
 *           - this is basically a non-blocking version of fgets
 */

char *_PC_fgets(bf, len, fp)
   char *bf;
   int len;
   FILE *fp;
   {int n;

#undef fgets

    if (fp == stdin)
       {if (IZGETMR(bf, &len, &_PC_unblock, &n))
           {*bf = '\0';
            bf  = NULL;}
        else
           bf[n] = '\0';}
    else
       return(fgets(bf, len, fp));

    return(bf);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_GETS - do basic read operation on NLTSS */

static int _PC_nltss_gets(bf, len, pp)
   char *bf;
   int len;
   PROCESS *pp;
   {int flag, nrcv, oneless;

    PC_ERR_TRAP(-1);

    if (pp->status != RUNNING)
       return(-1);

    oneless = len - 1;
    switch (flag = IZGETME(bf, &oneless, &Zero_I, &nrcv)) 
       {case MESSAGE_RECEIVED      :
             if (strncmp(bf, "\r\x0a all done\r\x0a", 13) != 0)
                {pp->status = RUNNING; 
                 PC_flush(pp);
                 bf[nrcv] = '\0';}

/* case of "all done" */
             else
                {pp->status = EXITED; 
                 bf = NULL;};
             break;

        case RECEIVE_STATE          :
             pp->status = RUNNING;
             bf = NULL;
             break;

        case NO_CONTROLLEE_ATTACHED :
             pp->status = STOPPED; 
             bf = NULL;
             break;

        default:
             PC_error("COULDN'T GET MESSAGE FROM PROCESS (%d) - _PC_NLTSS_GETS", 
                      flag);
             bf = NULL;
             break;};

    return(nrcv);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_IN_READY - return input ready status of process */

static _PC_nltss_in_ready(pp)
   PROCESS *pp;
   {return(_PC_unblock);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_CLOSE - kill the process in effect closing the file
 *                 - release the PROCESS (be careful about using pp
 *                 - after this!!) clean up the details too
 */

static int _PC_nltss_close(pp)
   PROCESS *pp;
   {int in, out, id, flag, dummy;

    PC_flush(pp);

    PC_ERR_TRAP(FALSE);

    if (pp == NULL)
       return(FALSE);

    in  = pp->in;
    out = pp->out;
    id  = pp->id;

    _PC_delete_process(pp);

/* kill the process itself */
    flag = IZDSCNEK(&dummy);
    if (flag != 0)
       PC_error("COULDN'T DISCONNECT PROCESS (%d) - _PC_NLTSS_CLOSE",
                flag);

/* close the communications pipe */
    pp->release(pp);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_FLUSH - flush the input and output streams
 *                 - for the given process
 */

static int_PC_nltss_flush(pp)
   PROCESS *pp;
   {int len1, flag;
    char empty[1];

    if (pp == NULL)
       return(FALSE);

    PC_ERR_TRAP(FALSE);

/* send a blank message to controllee (obviously) */
    len1 = -1;
    flag = IZSNDME(empty, &len1, &Zero_I);
    if (flag == NO_CONTROLLEE_TO_SEND)
       PC_error("COULDN'T SEND BLANK MESSAGE TO PROCESS (%d) - PC_FLUSH", 
                flag);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_NLTSS_PRINTF - do an fprintf style output to a process */

static int _PC_nltss_printf(pp, buffer)
   PROCESS *pp;
   char *buffer;
   {int len, flag;
  
    len = strlen(buffer);

    PC_ERR_TRAP(FALSE);

    buffer[len] = '\0';
    flag = IZSNDME(buffer, &len, &Zero_I);
    if (flag != 0)
       PC_error("ERROR WRITING TO PROCESS (%d) - PC_PRINTF", flag);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

