/*
 * GSVTST.C - test of vector routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - start it off here */

main()
   {int i, k, l, kmax, lmax, kxl;
    int id, lncolor, lnstyle, centering;
    REAL *x, *y, *u, *v, r, t, lnwidth;
    REAL xmin, xmax, ymin, ymax, km, lm;
    PG_device *SCR_dev, *PS_dev, *CGM_dev;
    PM_set *domain, *range;
    PG_graph *data;

/* set up the graphics window */
    SCR_dev = PG_make_device("WINDOW", "COLOR", "PGS Vector Test");

    PG_white_background(SCR_dev, TRUE);
    PG_set_viewport_pos(SCR_dev, 0.250, 0.150);
    PG_set_viewport_shape(SCR_dev, 0.500, 0.0, 0.500/0.333);

    PG_open_device(SCR_dev, 0.05, 0.2, 0.45, 0.45);

    PS_dev = PG_make_device("PS", "MONOCHROME", "gsctst");
    PG_open_device(PS_dev, 0.0, 0.0, 0.0, 0.0);

    CGM_dev = PG_make_device("CGM", "MONOCHROME", "gsctst");
    PG_open_device(CGM_dev, 0.0, 0.0, 0.0, 0.0);

/* set up data */
    kmax      = 20;
    lmax      = 20;
    xmin      = -5.0;
    xmax      = 5.0;
    ymin      = -5.0;
    ymax      = 5.0;
    id        = 'A';
    lncolor   = SCR_dev->BLUE;
    lnwidth   = 0.0;
    lnstyle   = SOLID;
    centering = N_CENT;

    kxl = kmax*lmax;
    x   = FMAKE_N(REAL, kxl, "GSVTST.C:x");
    y   = FMAKE_N(REAL, kxl, "GSVTST.C:y");
    u   = FMAKE_N(REAL, kxl, "GSVTST.C:u");
    v   = FMAKE_N(REAL, kxl, "GSVTST.C:v");

    km = 2.0*PI/((double) (kmax - 1));
    lm = 2.0*PI/((double) (lmax - 1));
    for (k = 0; k < kmax; k++)
        for (l = 0; l < lmax; l++)
            {i    = l*kmax + k;
             x[i] = k*km;
             y[i] = l*lm;
             u[i] = sin(k*km);
             v[i] = sin(l*lm);};

/* build the domain set */
    domain = PM_make_set("{x, y}", SC_REAL_S, FALSE,
			 2, kmax, lmax, 2, x, y);

/* build the range set */
    range = PM_make_set("{u, v}", SC_REAL_S, FALSE,
			2, kmax, lmax, 2, u, v);

    data = PG_make_graph_from_sets("{x, y}->{u, v}", domain, range,
				   centering,
				   SC_PCONS_P_S, NULL, id, NULL);

    PG_set_tdv_info(data->info, PLOT_VECTOR, CARTESIAN,
		    lnstyle, lncolor, lnwidth);

    PG_vector_plot(SCR_dev, data);
    PG_vector_plot(PS_dev, data);
    PG_vector_plot(CGM_dev, data);

    SC_pause();

    PG_close_device(SCR_dev);
    PG_close_device(PS_dev);
    PG_close_device(CGM_dev);

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
