/*
 * GSPR_GL.C - PGS GL primitive routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "pgs.h"

/*--------------------------------------------------------------------------*/

/*                         STATE QUERY ROUTINES                             */

/*--------------------------------------------------------------------------*/

/* _PG_GL_GET_TEXT_EXT_NDC - return the text extent in NDC
 *                         - of the given string
 */

void _PG_GL_get_text_ext_NDC(dev, s, px, py)
   PG_device *dev;
   char *s;
   REAL *px, *py;
   {REAL tx, ty;
    int ix, iy, len, dir, asc, dsc;
    XCharStruct overall;
    XFontStruct *fnt;
    Display *disp;

    disp = dev->display;
    if (disp == NULL)
       return;

    len = strlen(s);
    fnt = dev->font_info;
    XTextExtents(fnt, s, len, &dir, &asc, &dsc, &overall);
    
    ix = overall.width;
    iy = asc + dsc;

    tx = ix/dev->window_width;
    ty = iy/dev->window_height;

    *px = tx;
    *py = ty;

    return;}

/*--------------------------------------------------------------------------*/

/*                          STATE CHANGE ROUTINES                           */

/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SET_LOGICAL_OP - set the logical operation */
 
void _PG_GL_set_logical_op(dev, lop)
   PG_device *dev;
   int lop;
   {Display *disp;
    GC xgc;

    dev->logical_op = lop;

    disp = dev->display;
    if (disp == NULL)
       return;

    xgc = dev->gc;

    glEnable(GL_LOGIC_OP);

    switch (lop)
      {case GS_XOR :
	    glLogicOp(GL_XOR);
	    XSetFunction(disp, xgc, GXxor);
	    break;

       default      :
       case GS_COPY :
            glLogicOp(GL_COPY);     
	    glDisable(GL_LOGIC_OP);
	    XSetFunction(disp, xgc, GXcopy);
	    break;};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_LINE_STYLE - set the line style */
 
void _PG_GL_set_line_style(dev, style)
   PG_device *dev;
   int style;
   {GLushort patt;

    dev->line_style = style;

    glEnable(GL_LINE_STIPPLE);

    switch (style)
      {case LINE_DASHED :
	    patt = 0xF0F0;
	    break;

       case LINE_DOTTED :
	    patt = 0x8888;
	    break;

       case LINE_DOTDASHED :
	    patt = 0xD4D4;
	    break;

       default         :
       case LINE_SOLID :
	    patt = 0xFFFF;
	    glDisable(GL_LINE_STIPPLE);
	    break;};
 
    glLineStipple(1, patt);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SET_LINE_WIDTH - set the line width */
 
void _PG_GL_set_line_width(dev, width)
   PG_device *dev;
   double width;
   {GLdouble lwd;

    dev->line_width = width;

    lwd = 3.0*max(width, 0.3333333333);
    glLineWidth(lwd);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SET_LINE_COLOR - set the line color */
 
void _PG_GL_set_line_color(dev, clr, mapped)
   PG_device *dev;
   int clr, mapped;
   {

    dev->line_color = clr;
    if (mapped)
       clr = _PG_trans_color(dev, clr);

    glIndexi((GLint) dev->current_palette->pixel_value[clr]);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SET_TEXT_COLOR - set the color of the text */
 
void _PG_GL_set_text_color(dev, clr, mapped)
   PG_device *dev;
   int clr, mapped;
   {unsigned short *pi;
    Display *disp;

    dev->text_color = clr;

    disp = dev->display;
    if (disp == NULL)
       return;

    if (mapped)
       clr = _PG_trans_color(dev, clr);

    pi = dev->current_palette->pixel_value;
    glIndexi((GLint) pi[clr]);
    XSetForeground(disp, dev->gc, pi[clr]);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_FILL_COLOR - sets current fill color */

void _PG_GL_set_fill_color(dev, clr, mapped)
   PG_device *dev;
   int clr, mapped;
   {

    dev->fill_color = clr;
    if (mapped)
       glIndexi((GLint) dev->current_palette->pixel_value[clr]);
    else
       glIndexi((GLint) clr);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_CHAR_SIZE_NDC - set the character size in NCD */

void _PG_GL_set_char_size_NDC(dev, x, y)
   PG_device *dev;
   double x, y;
   {

    dev->char_height_s = (REAL) y;
    dev->char_width_s  = (REAL) x;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_CHAR_PATH - set the direction along which text will be written
 *                      - defaults to (1, 0)
 */

void _PG_GL_set_char_path(dev, x, y)
   PG_device *dev;
   double x, y;
   {

    dev->char_path_x = (REAL) x;
    dev->char_path_y = (REAL) y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_CHAR_PRECISION - set the character precision
 *                           - fast and fixed size or
 *                           - slow and flexible
 */

void _PG_GL_set_char_precision(dev, p)
   PG_device *dev;
   int p;
   {

    dev->char_precision = p;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_CHAR_SPACE - set the space between characters */

void _PG_GL_set_char_space(dev, s)
   PG_device *dev;
   double s;
   {

    dev->char_space = (REAL) s;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_SET_CHAR_UP - set the direction which is up for individual
 *                    - characters
 *                    - defaults to (0, 1)
 */

void _PG_GL_set_char_up(dev, x, y)
   PG_device *dev;
   double x, y;
   {

    dev->char_up_x = (REAL) x;
    dev->char_up_y = (REAL) y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SET_CHAR_LINE - set the number characters per line */
 
void _PG_GL_set_char_line(dev, n)
   PG_device *dev;
   int n;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SET_CLIPPING - set clipping
 *                     - flag = FALSE  -->  clipping off
 *                     - flag = TRUE   -->  clipping on
 */

void _PG_GL_set_clipping(dev, flag)
   PG_device *dev;
   int flag;
   {int ix0, iy0, ix1, iy1;
    int iw, ih;
    REAL xmin, xmax, ymin, ymax;
    XRectangle cliprect[1];
    Display *disp;
    double xma, yma;

    disp = dev->display;
    if (disp == NULL)
       return;

    PG_get_viewport_WC(dev, &xmin, &xmax, &ymin, &ymax);

    _PG_find_clip_region(dev, xmin, xmax, ymin, ymax,
                         &ix0, &iy0, &ix1, &iy1, flag, FALSE);

    iw = ix1 - ix0 + 1;
    ih = iy1 - iy0 + 1;

    cliprect[0].x = 0;
    cliprect[0].y = 0;
    cliprect[0].width = iw;
    cliprect[0].height = ih;
 
    XSetClipRectangles(disp, dev->gc, ix0, iy0, cliprect, 1, Unsorted);

    glXMakeCurrent(dev->display, dev->window, dev->glxgc);
    glLoadIdentity();
    if (flag)
       {if (dev->ifxlog)
	   {xmax = log10(ABS(xmax) + SMALL);
	    xmin = log10(ABS(xmin) + SMALL);
	    xma = xmax - _PG_axis_n_decades;
	    xmin = max(xmin, xma);};
	if (dev->ifylog)
	   {ymax = log10(ABS(ymax) + SMALL);
	    ymin = log10(ABS(ymin) + SMALL);
	    yma = ymax - _PG_axis_n_decades;
	    ymin = max(ymin, yma);};
	WtoS(dev, xmin, ymin);
	WtoS(dev, xmax, ymax);
	glOrtho(xmin, xmax, ymin, ymax, -1.0, 1.0);}
    else
       glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
    glViewport(ix0, dev->window_height - ih - iy0 + 1, iw, ih);

    dev->clipping = flag;

    return;}
 
/*--------------------------------------------------------------------------*/

/*                          MOVE AND DRAW ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_GL_MOVE_GR_ABS - move the current graphics cursor position to the
 *                    - given absolute coordinates in WC
 */
 
void _PG_GL_move_gr_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->gcurx = x;
    dev->gcury = y;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_MOVE_TX_ABS - move the current text cursor position to the
 *                    - given coordinates in WC
 */
 
void _PG_GL_move_tx_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx = x;
    dev->tcury = y;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_MOVE_TX_REL - move the current text cursor position to the
 *                    - given relative coordinates in WC
 */
 
void _PG_GL_move_tx_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {

/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx += x;
    dev->tcury += y;
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_DRAW_TO_ABS - draw a line from current position to
 *                    - absolute position (x, y) in WC
 */
 
void _PG_GL_draw_to_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {GLdouble x1, y1;
 
/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);

    x1 = dev->gcurx;
    y1 = dev->gcury;

    dev->gcurx = x;
    dev->gcury = y;

    WtoS(dev, x1, y1);
    WtoS(dev, x, y);

    glBegin(GL_LINE_STRIP);
    glVertex2d(x1, y1);
    glVertex2d((GLdouble) x, (GLdouble) y);
    glEnd();
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_DRAW_TO_REL - draw a line from current position to
 *                    - relative position (x, y)
 *                    - in WC
 */
 
void _PG_GL_draw_to_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {GLdouble x1, y1, x2, y2;

/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    x1 = dev->gcurx;
    y1 = dev->gcury;
    x2 = dev->gcurx + x;
    y2 = dev->gcury + y;

    dev->gcurx = x2;
    dev->gcury = y2;

    WtoS(dev, x1, y1);
    WtoS(dev, x2, y2);
 
    glBegin(GL_LINE_STRIP);
    glVertex2d(x1, y1);
    glVertex2d(x2, y2);
    glEnd();
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_DRAW_CURVE - plot the points from a PG_curve */
 
void _PG_GL_draw_curve(dev, crv, clip)
   PG_device *dev;
   PG_curve *crv;
   int clip;
   {int n, j, xo, yo;
    int *x, *y;
    GLdouble v[2];

    n  = crv->n;
    x  = crv->x;
    y  = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;
    
    glBegin(GL_LINE_STRIP);
    for (j = 0; j < n; j++)
	{PtoS(dev, xo + x[j], yo + y[j], v[0], v[1])
	 glVertex2dv(v);};
    glEnd();
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_DRAW_DISJOINT_POLYLINE_2 - draws disjoint two dimensional
 *                                 - line segments specified in WC
 */

void _PG_GL_draw_disjoint_polyline_2(dev, x, y, n, flag, coord)
   PG_device *dev;
   REAL *x, *y;
   long n;
   int flag, coord;
   {REAL *px, *py;
    REAL x1, y1, x2, y2;
    int j;
    GLdouble v1[2], v2[2];

    if (n == 0)
       return;

/* if auto ranging or domaining is on the data will control the WC system */
    if (flag && (dev->autorange || dev->autodomain))
       PG_set_limits(dev, x, y, 2*n, CARTESIAN);

    px = x;
    py = y;

    PG_move_gr_abs(dev, x[0], y[0]);

    for (j = 0; j < n; j++)
        {x1 = *px++;
	 y1 = *py++;
	 x2 = *px++;
	 y2 = *py++;

	 if (coord)
	    {if (dev->ifxlog)
	        {x1 = log10(ABS(x1) + SMALL);
		 x2 = log10(ABS(x2) + SMALL);};
	     if (dev->ifylog)
	        {y1 = log10(ABS(y1) + SMALL);
		 y2 = log10(ABS(y2) + SMALL);};

	     WtoS(dev, x1, y1);
	     WtoS(dev, x2, y2);};
 
         v1[0] = x1;
	 v1[1] = y1;
	 v2[0] = x2;
	 v2[1] = y2;

	 glBegin(GL_LINES);
	 glVertex2dv(v1);
	 glVertex2dv(v2);
	 glEnd();};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_SHADE_POLY - polygon shading routine */

void _PG_GL_shade_poly(dev, x, y, n)
   PG_device *dev;
   REAL *x, *y;
   int n;
   {int i;
    GLdouble v[2];
    GLenum mode;

    n--;

/* GOTCHA: This only works for convex polygons - tessellation needed */

    if (n == 3)
       mode = GL_TRIANGLES;
    else if (n == 4)
       mode = GL_QUADS;
    else
       mode = GL_POLYGON;

    glBegin(mode);
    for (i = 0; i < n; i++)
        {v[0] = x[i];
         v[1] = y[i];
         WtoS(dev, v[0], v[1]);
	 glVertex2dv(v);};
    glEnd();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_GL_FILL_CURVE - fill closed curves */

void _PG_GL_fill_curve(dev, crv)
   PG_device *dev;
   PG_curve *crv;
   {int i, n, xo, yo;
    int *x, *y;
    GLdouble v[2];
    GLenum mode;

    n  = crv->n - 1;
    x  = crv->x;
    y  = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;
    
/* GOTCHA: This only works for convex polygons - tessellation needed */

    if (n == 3)
       mode = GL_TRIANGLES;
    else if (n == 4)
       mode = GL_QUADS;
    else
       mode = GL_POLYGON;

    glBegin(mode);
    for (i = 0; i < n; i++)
	{PtoS(dev, xo + x[i], yo + y[i], v[0], v[1]);
	 glVertex2dv(v);};
    glEnd();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_PUT_IMAGE - put the image on the screen
 *                  - the image buffer may be overwritten by the pseudo color
 *                  - mapping if it is needed!!
 */

void _PG_GL_put_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {int i, k, l, n;
    int n_pal_colors, n_dev_colors;
    unsigned short *pixel_value;
    unsigned char c, *pbf1, *pbf2;
    GLdouble v[2];
    PG_palette *pal;
    RGB_color_map *pseudo_cm;

    pal          = dev->current_palette;
    n_dev_colors = dev->absolute_n_color;
    n_pal_colors = pal->n_pal_colors;
    pseudo_cm    = pal->pseudo_colormap;

    PG_invert_image_data(bf, nx, ny, 1);

    if ((n_dev_colors < n_pal_colors) && (pseudo_cm != NULL))
       {unsigned char *pbf;
	REAL rv;

        pbf = bf;
        PM_random(-1);
        for (l = 0; l < ny; l++)
            for (k = 0; k < nx; k++)
                {i      = *pbf;
                 rv     = 3.5*PM_random(1) - 0.83;
                 *pbf++ = (rv < pseudo_cm[i].red) ?
                          pseudo_cm[i].green : pseudo_cm[i].blue;};};

/* map the pixel values to the colors */
    n = nx*ny;
    pixel_value = pal->pixel_value;
    for (i = 0; i < n; i++)
        bf[i] = pixel_value[bf[i]];

/* turn image rightside up */
    pbf1 = bf;
    for (l = 0; l < (ny/2); l++)
        {pbf2 = bf + (ny - l - 1)*nx;
	 for (k = 0; k < nx; k++)
	     {c       = *pbf1;
	      *pbf1++ = *pbf2;
	      *pbf2++ = c;};};

    iy = iy + ny - 1;
    PtoS(dev, ix, iy, v[0], v[1]);
    glRasterPos2dv(v);
    glDrawPixels(nx, ny, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, bf);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GL_GET_IMAGE - get the image on the screen into
 *                  - the image buffer
 */

void _PG_GL_get_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {

     glReadPixels(ix, iy, nx, ny, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, bf);
     
     return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

