/*
 * GSIMTS.C - test the image drawing routines in PGS
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 

#include "pgs.h"

#ifdef MAC
#define SLOW
#else
#define FAST
#endif

static char
 *palettes[] = {"spectrum", "rainbow", "bw"};

static void
 SC_DECLARE(print_help, (byte));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char **argv;
   {int i, k, l;
    int X_max, Y_max, use_color, palette;
    double dx, dy, x, y, sf, *bf;
    char *s;
    PG_image *calc_im;
    PG_device *SCR_dev, *SCR_dew, *PS_cdev, *CGM_cdev, *PS_mdev, *CGM_mdev;

#ifdef SLOW

    X_max  = 50;
    Y_max  = 50;

#else

    X_max  = 250;
    Y_max  = 250;

#endif
/*
    X_max  = 8;
    Y_max  = 8;
*/
    sf = 256.0;

    palette   = 0;
    use_color = FALSE;
    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'c' : use_color = TRUE;
                            break;
                 case 'p' : palette = atoi(argv[++i]);
                            break;
                 case 'h' : print_help();
                            return(1);
                 case 'z' : X_max = Y_max = atoi(argv[++i]);
                            break;};}

         else
            break;};

#ifndef SLOW

    PS_cdev  = PG_make_device("PS", "COLOR", "gsimts-c");
    CGM_cdev = PG_make_device("CGM", "COLOR", "gsimts-c");
    PS_mdev  = PG_make_device("PS", "MONOCHROME", "gsimts-m");
    CGM_mdev = PG_make_device("CGM", "MONOCHROME", "gsimts-m");

    PG_open_device(PS_cdev, 0.0, 0.0, 0.0, 0.0);
    PG_open_device(CGM_cdev, 0.0, 0.0, 0.0, 0.0);
    PG_open_device(PS_mdev, 0.0, 0.0, 0.0, 0.0);
    PG_open_device(CGM_mdev, 0.0, 0.0, 0.0, 0.0);

#endif

    calc_im = PG_make_image("Test Image", "double", NULL,
                            0.0, 0.0, 0.0, 0.0, 0.0, 256.0,
                            X_max, Y_max, 8, NULL);
    if (calc_im == NULL)
       {PRINT(STDOUT, "CAN'T ALLOCATE IMAGE");
        exit(1);};

    s = SC_strsavef("WINDOW", "char*:GSIMTS:s");

/* calculate the first image */
    bf = (double *) calc_im->buffer;
    for (l = 0; l < Y_max; l++)
        {for (k = 0; k < X_max; k++)
             *bf++ = sf*((double) k)*((double) l)/
                           ((double) (Y_max - 1)*(X_max - 1));};

/* open the first window */
    SCR_dev = PG_make_device(s, "COLOR", "PGS Image Test");

    PG_white_background(SCR_dev, FALSE);
    PG_open_device(SCR_dev, 0.05, 0.1, 0.4, 0.4);
/*    PG_open_device(SCR_dev, 0.05, 0.1, 0.01, 0.01); */

    PG_set_viewport(SCR_dev, 0.0, 1.0, 0.0, 1.0);
    PG_set_window(SCR_dev, 0.0, 1.0, 0.0, 1.0);

    PG_set_palette(SCR_dev, "spectrum");

/* draw the first image */
    PG_draw_image(SCR_dev, calc_im, "Test Data A", NULL);

#ifndef SLOW
    PG_set_palette(PS_mdev, palettes[palette]);
    PG_draw_image(PS_mdev, calc_im, "Test Data HC", NULL);

    PG_set_palette(PS_cdev, palettes[palette]);
    PG_draw_image(PS_cdev, calc_im, "Test Data HC", NULL);

    PG_white_background(CGM_mdev, TRUE);
    PG_set_palette(CGM_mdev, palettes[palette]);
    PG_draw_image(CGM_mdev, calc_im, "Test Data HC", NULL);

    PG_white_background(CGM_cdev, TRUE);
    PG_set_palette(CGM_cdev, palettes[palette]);
    PG_draw_image(CGM_cdev, calc_im, "Test Data HC", NULL);
#endif

    SC_pause();

/* compute the second image */
    dx = 2.0*PI/((double) X_max);
    dy = 2.0*PI/((double) Y_max);
    bf = (double *) calc_im->buffer;
    for (l = 0; l < Y_max; l++)
        {for (k = 0; k < X_max; k++)
             {x = ((double) k)*dx;
              y = ((double) l)*dy;
	      *bf++ = sf*(0.5 + 0.5*sin(x)*cos(y));};};

/* open the second window */
    SCR_dew = PG_make_device(s, "COLOR", "PGS Image Test");

    PG_white_background(SCR_dew, TRUE);
    PG_open_device(SCR_dew, 0.55, 0.1, 0.4, 0.4);

    PG_set_viewport(SCR_dew, 0.0, 1.0, 0.0, 1.0);
    PG_set_window(SCR_dew, 0.0, 1.0, 0.0, 1.0);

    PG_set_palette(SCR_dew, "cym");
    PG_clear_window(SCR_dew);

/* draw the second image */
    PG_draw_image(SCR_dew, calc_im, "Test Data B", NULL);

    SC_pause();

    PG_close_device(SCR_dev);
    PG_close_device(SCR_dew);

#ifndef SLOW
    PG_close_device(PS_cdev);
    PG_close_device(CGM_cdev);
    PG_close_device(PS_mdev);
    PG_close_device(CGM_mdev);
#endif

    PG_rl_image(calc_im);

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PRINT_HELP - print a help message */

static void print_help()
   {PRINT(STDOUT, "\nGSIMTS - test the image plotting in PGS\n");
    PRINT(STDOUT, "\n");

    PRINT(STDOUT, "Usage: gsimts [-h] [-p] [-z #]\n");
    PRINT(STDOUT, "\n");

    PRINT(STDOUT, "       -h  Print this help message and exit\n");
    PRINT(STDOUT, "       -p  palette 0 - spectrum, 1 - rainbow, 2 - bw\n");
    PRINT(STDOUT, "       -z  Use the specified number of zones on a side\n");

    PRINT(STDOUT, "\n");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
