/*
 * GSFPTS.C - test of polygon fill plot
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"
#include "gsrast.h"

static char
 *palettes[] = {"spectrum", "rainbow", "bw"};

static void
 SC_DECLARE(print_help, (byte));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - start it off here */

main(argc, argv)
   int argc;
   char **argv;
   {int i, k, l, kmax, lmax, kxl;
    int id, lncolor, lnstyle, centering, palette;
    REAL *x, *y, *f, r, t, lnwidth;
    REAL xmin, xmax, ymin, ymax;
    PG_device *SC_dev, *PS_dev;
    PG_graph *data;

    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'p' : palette = atoi(argv[++i]);
                            break;
                 case 'h' : print_help();
                            return(1);};}
         else
            break;};

/* set up data */
    palette = 1;
    kmax    = 20;
    lmax    = 20;
    xmin    = -5.0;
    xmax    = 5.0;
    ymin    = -5.0;
    ymax    = 5.0;
    kxl     = kmax*lmax;
    x       = FMAKE_N(REAL, kxl, "GSFPTS.C:x");
    y       = FMAKE_N(REAL, kxl, "GSFPTS.C:y");
    f       = FMAKE_N(REAL, kxl, "GSFPTS.C:f");
    id      = 'A';

    for (k = 0; k < kmax; k++)
        for (l = 0; l < lmax; l++)
            {i    = l*kmax + k;
             x[i] = k/10.0 - 5.0;
             y[i] = l/10.0 - 5.0;
             r    = x[i]*x[i] + y[i]*y[i];
             t    = 5.0*atan(y[i]/(x[i] + SMALL));
             r    = POW(r, 0.125);
             f[i] = exp(-r)*(1.0 + 0.1*cos(t));};

/* set up the graphics window */
    SC_dev = PG_make_device("WINDOW", "COLOR", "PGS Polygon Fill Test A");
    lncolor   = SC_dev->BLUE;
    lnwidth   = 0.0;
    lnstyle   = SOLID;
    PG_white_background(SC_dev, TRUE);
    PG_open_device(SC_dev, 0.05, 0.1, 0.4, 0.4);

    setbuf(STDOUT, NULL);
/*    PG_register_device("JPEG", PG_setup_jpeg_device);*/
    PS_dev = PG_make_device("JPEG", "COLOR", "gsfpts");
    PG_open_device(PS_dev, 0.0, 0.0, 512.0, 512.0);

    centering = N_CENT;
    data = PG_make_graph_r2_r1(id, "{x, y}->f", FALSE,
                     kmax, lmax, centering, x, y, f, "xy", "f");

    PG_set_palette(SC_dev, palettes[palette]);
    PG_poly_fill_plot(SC_dev, data);

    PG_set_palette(PS_dev, palettes[palette]);
    PG_poly_fill_plot(PS_dev, data);
    PG_finish_plot(PS_dev);

    SC_pause();
    PG_close_device(SC_dev);
    PG_close_device(PS_dev);
    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PRINT_HELP - print a help message */

static void print_help()
   {PRINT(STDOUT, "\nGSFPTS - test the polygon fill plotting in PGS\n");
    PRINT(STDOUT, "\n");

    PRINT(STDOUT, "Usage: gsfpts [-h] [-p]\n");
    PRINT(STDOUT, "\n");

    PRINT(STDOUT, "       -h  Print this help message and exit\n");
    PRINT(STDOUT, "       -p  palette 0 - spectrum, 1 - rainbow, 2 - bw\n");

    PRINT(STDOUT, "\n");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
