/*
 * PXRDTS.C - Test attribute features of PDBX (READ version)
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main()
   {PDBfile *file;
    float d[10];
    int i, *rank, *center;
    char **names;
    HASHTAB *tab;

    if ((file = PD_open("xtest.dat", "r")) == NULL)
       {printf("Error opening xtest.dat\n");
	exit(1);};

/* print contents of symbol table */
    names = SC_hash_dump(file->symtab, NULL);
    printf("\nSymbol Table:\n");
    for (i = 0; i < file->symtab->nelements; i++)
	if (names[i] != NULL)
	   printf("%s\n", names[i]);
    printf("--------\n");

/* print contents of attribute table */
    printf("\nAttribute Table:\n");
    if ((names = SC_hash_dump(file->attrtab, NULL)) == NULL)
       printf("Couldn't dump out attribute table\n");
    else
       {for (i = 0; i < file->attrtab->nelements; i++)
	    if (names[i] != NULL)
	       printf("%s\n", names[i]);};
    printf("--------\n");

/* read the one "physics" variable */
    PD_read(file, "d", d);

    for (i = 0; i < 10; i++)
	printf("d[%d] = %f\n", i, d[i]);
    printf("\n");

/* get some attribute values */
    rank = (int *) PD_get_attribute(file, "d", "rank");
    if (rank == NULL)
       printf("Error getting rank attribute\n");
    printf("rank = %d\n", *rank);

    center = *(int **) PD_get_attribute(file, "d", "centering");
    if (center == NULL)
       printf("Error getting center attribute\n");
    printf("center[0] = %d ; [1] = %d\n", center[0], center[1]);

/* can we read second copy of att hash tab? */
    tab = FMAKE(HASHTAB, "PXRDTS.C:tab");

    if ((PD_read(file, "foo", tab)) == FALSE)
       {printf("Error reading attribute hash table from file.\n");
	printf("PD_err = %s\n", PD_err);};

/* print contents of hash tab we just read */
    if ((names = SC_hash_dump(tab, NULL)) == NULL)
       printf("Couldn't dump hash tab from PD_read_table\n");
    else
       {printf("\nAttribute Table from PD_read_table:\n");
	for (i = 0; i < tab->nelements; i++)
	    if (names[i] != NULL)
	       printf("%s\n", names[i]);};
    printf("--------\n");

/* close file */
    PD_close(file);

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
