/* testtypes.c */

#include <stdio.h>
#include <opt.h>

int aint = 1;
unsigned int buint = 2;
short cshort = 3;
long dlong = 4;
char echar = '5';
int flevel = 6;
float ffloat = 7.0;
double gdouble = 8.0;
int hflag = OPT_TRUE;
int inegflag = OPT_FALSE;
int jabsflag = OPT_TRUE;
int kabsnegflag = OPT_FALSE;
char *lvstring = NULL;
char mcstring[OPT_MAXSTRLEN];

int oldmain(int argc, char **argv)
{
    printf("a=%d, b=%u, c=%hd, d=%ld, e=[%c]\n",
           aint,buint,cshort,dlong,echar);
    return OPT_OK;
}

main(int argc, char **argv)
{
    optreg_INT(&aint,'a',"int");
    optreg_UNSINT(&buint,'b',"unsigned int");
    optreg_SHORT(&cshort,'c',"short");
    optreg_LONG(&dlong,'d',"long");
    optreg_CHAR(&echar,'e',"char");
    optreg_INTLEVEL(&flevel,'F',"int level");
    optreg_FLOAT(&ffloat,'f',"float");
    optreg_DOUBLE(&gdouble,'g',"double");
    optreg_FLAG(&hflag,'h',"flag");
    optreg_ABSFLAG(&jabsflag,'j',"abs flag");
    optreg_ABSNEGFLAG(&kabsnegflag,'k',"abs neg flag");
    optreg_VSTRING(&lvstring,'l',"v-string");

    /* NOTE: the CSTRING is the only type in which the
     * actual variable name is used instead of a pointer
     * to the variable name!  However, on many systems,
     * &mcstring and mcstring are identical, so it doesn't
     * really matter.!
     */
    optreg_CSTRING(mcstring,'m',"c-string");

    optMain(oldmain);

    opt(&argc,&argv);

    return oldmain(argc,argv);
}
