(* 	$Id: CopyPropagation.Mod,v 1.2 1995/11/10 17:28:32 oberon2 Exp $	 *)
MODULE CopyPropagation;  (* Copyright (C) 1995  Juergen Zimmermann *)

IMPORT D := Data, Opc := Opcode;

PROCEDURE Propagate* (reg: D.Region);
  VAR
    instr, nextInstr: D.Instruction;
  BEGIN
    instr := reg. instrList;
    WHILE (instr # NIL) DO
      nextInstr := instr. nextInstr;
      IF (instr IS D.Region) THEN
        (* recursivly visit all embedded regions *)
        Propagate (instr(D.Region))
      ELSIF (instr. opcode = Opc.copy) THEN
        (* replace all uses of this 'copy' instruction by the first (and only)
           operand of the 'copy' instruction, then delete the 'copy' 
           instruction since it is dead code now  *)
        D.ReplaceUses (instr, instr. opndList. arg);
        D.Delete (instr)
      END;
      instr := nextInstr
    END
  END Propagate;
    
END CopyPropagation.


