/*	$Id: __StdTypes.h,v 1.8 1998/07/28 15:17:31 acken Exp $	*/
#ifndef __StdTypes__
#define __StdTypes__

#include "__config.h"
#define hugeint LOCAL_INT64_T


/* these types should be used when writing a C function whose header has to
   correspond to an Oberon-2 declaration; the mapping defined here has to
   be equal to the one defined in StdTypes.BasicTypes; note that the names 
   defined here are not used in code generated by oo2c  */
typedef unsigned char BOOLEAN;
typedef unsigned char CHAR;
typedef signed char SHORTINT;
typedef signed short int INTEGER;
typedef signed int LONGINT;
typedef hugeint HUGEINT;
typedef float REAL;
typedef double LONGREAL;
typedef unsigned char SET8;
typedef unsigned short int SET16;
typedef unsigned int SET32;
typedef unsigned hugeint SET64;
typedef SET32 SET;
typedef unsigned char BYTE;
typedef void *PTR;

/* format string used by printf for LONGINT (%i if it is equal to int,
   %li if it is long int) */
#define LI_FORMAT "%i"

#ifndef NULL
#define NULL (void*)0
#endif

typedef unsigned int _ModId;
typedef unsigned int _Pos;	/* type to hold file positions */



/* define some useful macros; none of these macros is used by the compiler 
   itself, but they should ease the implementation of FOREIGN modules */

/* allocate a new heap object to hold a record of type `_type' and place the
   pointer into `_dest'; include "__mini_gc.h" and <stdlib.h> if you use this 
   macro */
#define NEW_REC(_dest,_type) { 					\
  char *_mem, *_var;						\
  _mem = GC_malloc(_type##__td.td.size + (sizeof(void*)<<1));	\
  _var = _mem + (sizeof(void*)<<1);				\
  ((_Type*)_var)[-1] = &_type##__td.td;				\
  _dest = (_type*)_var;						\
}

/* call the type-bound procedure `_index' (an integer value) associated with
   the pointer variable `_ptr'; `_cast' describes the function type of the
   activated procedure (it includes parenthesis), `_param' is the argument list
   of the call (including parenthesis around the arguments) */
#define TB_CALL(_ptr,_index,_cast,_param) (_cast((*((_TypeDesc**)(_ptr)-1))->tbprocs[_index]))_param

/* return the type tag of the given heap object */
#define TYPE_TAG(_ptr) ((_Type*)(_ptr))[-1]

/* return the type tag of the given record type */
#define TYPE_DESCR(_type) &_type##__td.td

#endif  /* __StdTypes__ */
