// Usage:  client -i <stringified IOR>
//         client <COSNaming compound name (e.g. x/y/echo.obj)>

#include <stdlib.h>
#include <iostream.h>
#include <echo.hh>
#include <common/common.h>

void hello(CORBA::Object_ptr obj);

CORBA::Boolean
trans_exc(void*, CORBA::ULong retries,const CORBA::TRANSIENT&)
{
  return 0;
}


int
main (int argc, char **argv) 
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
        CosNaming::Name use_name = string_to_name(argv[1]);
        obj = getObjectReference(orb,use_name);
      }
      catch (...) {
        obj = CORBA::Object::_nil(); 
	  }
      if (CORBA::is_nil(obj)) {
	    cerr << "Cannot resolve compound name to an object reference."
				  << endl;
	    return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	    cerr << "Cannot convert stringified IOR to an object reference."
	          << endl;
	    return 1;
      }
      break;
    }
  default:
    cerr << "usage: client -i <stringified IOR>" << endl;
    cerr << "       client <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }


  omniORB::traceLevel = 15;
  omniORB::installTransientExceptionHandler(0,trans_exc);

  CORBA::Boolean cont = 1;
  CORBA::ULong nth = 0;
  while (cont) {
    try {
      hello(obj);
    }
    catch(omniORB::fatalException& ex) {
      cerr << "Caught omniORB2 fatalException. This indicates a bug is caught "
	   << "within omniORB2.\nPlease send a bug report.\n"
	   << "The exception was thrown in file: " << ex.file() << "\n"
	   << "                            line: " << ex.line() << "\n"
	   << "The error message is: " << ex.errmsg() << endl;
      cont = 0;
    }
    catch(CORBA::SystemException &ex) {
      cerr << "Caught a system exception." << endl;
      cont = 0;
    }
    omni_thread::sleep(0,500000000);
  }
  return 0;
}

#define report_sysexcept(what,var) cerr << "Caught CORBA::" << what << endl

void
hello(CORBA::Object_ptr obj)
{
  Echo_var e = Echo::_narrow(obj);

  if (CORBA::is_nil(e)) {
    cerr << "hello: cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  CORBA::String_var src = (const char*) "Hello!"; // String literals are not
                                                  // const char*. Must do
                                                  // explicit casting to 
                                                  // force the use of the copy
                                                  // operator=(). 
  CORBA::String_var dest;

  try {
    dest = e->echoString(src);
  }
  catch (const CORBA::UNKNOWN &ex) {
    report_sysexcept ("UNKNOWN",ex);
    return;
  }
  catch (const CORBA::BAD_PARAM &ex) {
    report_sysexcept ("BAD_PARAM",ex);
    return;
  }
  catch (const CORBA::NO_MEMORY &ex) {
    report_sysexcept ("NO_MEMORY",ex);
    return;
  }
  catch (const CORBA::IMP_LIMIT &ex) {
    report_sysexcept ("IMP_LIMIT",ex);
    return;
  }
  catch (const CORBA::COMM_FAILURE &ex) {
    report_sysexcept ("COMM_FAILURE",ex);
    return;
  }
  catch (const CORBA::INV_OBJREF &ex) {
    report_sysexcept ("INV_OBJREF",ex);
    return;
  }
  catch (const CORBA::OBJECT_NOT_EXIST &ex) {
    report_sysexcept ("OBJECT_NOT_EXIST",ex);
    return;
  }
  catch (const CORBA::NO_PERMISSION &ex) {
    report_sysexcept ("NO_PERMISSION",ex);
    return;
  }
  catch (const CORBA::INTERNAL &ex) {
    report_sysexcept ("INTERNAL",ex);
    return;
  }
  catch (const CORBA::MARSHAL &ex) {
    report_sysexcept ("MARSHAL",ex);
    return;
  }
  catch (const CORBA::INITIALIZE &ex) {
    report_sysexcept ("INITIALIZE",ex);
    return;
  }
  catch (const CORBA::NO_IMPLEMENT &ex) {
    report_sysexcept ("NO_IMPLEMENT",ex);
    return;
  }
  catch (const CORBA::BAD_TYPECODE &ex) {
    report_sysexcept ("BAD_TYPECODE",ex);
    return;
  }
  catch (const CORBA::BAD_OPERATION &ex) {
    report_sysexcept ("BAD_OPERATION",ex);
    return;
  }
  catch (const CORBA::NO_RESOURCES &ex) {
    report_sysexcept ("NO_RESOURCES",ex);
    return;
  }
  catch (const CORBA::NO_RESPONSE &ex) {
    report_sysexcept ("NO_RESPONSE",ex);
    return;
  }
  catch (const CORBA::PERSIST_STORE &ex) {
    report_sysexcept ("PERSIST_STORE",ex);
    return;
  }
  catch (const CORBA::BAD_INV_ORDER &ex) {
    report_sysexcept ("BAD_INV_ORDER",ex);
    return;
  }
  catch (const CORBA::TRANSIENT &ex) {
    report_sysexcept ("TRANSIENT",ex);
    return;
  }
  catch (const CORBA::FREE_MEM &ex) {
    report_sysexcept ("FREE_MEM",ex);
    return;
  }
  catch (const CORBA::INV_IDENT &ex) {
    report_sysexcept ("INV_IDENT",ex);
    return;
  }
  catch (const CORBA::INV_FLAG &ex) {
    report_sysexcept ("INV_FLAG",ex);
    return;
  }
  catch (const CORBA::INTF_REPOS &ex) {
    report_sysexcept ("INTF_REPOS",ex);
    return;
  }
  catch (const CORBA::BAD_CONTEXT &ex) {
    report_sysexcept ("BAD_CONTEXT",ex);
    return;
  }
  catch (const CORBA::OBJ_ADAPTER &ex) {
    report_sysexcept ("OBJ_ADAPTER",ex);
    return;
  }
  catch (const CORBA::DATA_CONVERSION &ex) {
    report_sysexcept ("DATA_CONVERSION",ex);
    return;
  }
  catch (const CORBA::TRANSACTION_REQUIRED &ex) {
    report_sysexcept ("TRANSACTION_REQUIRED",ex);
    return;
  }
  catch (const CORBA::TRANSACTION_ROLLEDBACK &ex) {
    report_sysexcept ("TRANSACTION_ROLLEDBACK",ex);
    return;
  }
  catch (const CORBA::INVALID_TRANSACTION &ex) {
    report_sysexcept ("INVALID_TRANSACTION",ex);
    return;
  }
  catch (const CORBA::WRONG_TRANSACTION &ex) {
    report_sysexcept ("WRONG_TRANSACTION",ex);
    return;
  }

  cerr << "I said,\"" << (char*)src << "\"."
       << " The Object said,\"" << (char*)dest <<"\"" << endl;
}

