#include <iostream.h>
#include "echo.hh"

CORBA::BOA_ptr boa;

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() {}
  virtual ~Echo_i() { cerr << "Echo_i::~Echo_i" << endl; }
  virtual char * echoString(const char *mesg);
};

char *
Echo_i::echoString(const char *mesg) {
  char *p = CORBA::string_dup(mesg);
  return p;
}

int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  if (argc < 2) {
    cerr << "usage: colocated <object reference>" << endl;
    return 1;
  }

  Echo_i *myobj = new Echo_i;
  myobj->_obj_is_ready(boa);

  {
    Echo_var myobjRef = myobj->_this();
    CORBA::String_var p = orb->object_to_string(myobjRef);
    cerr << "Echo Object: " << (char*)p << endl;
  }

  boa->impl_is_ready(0,1);

  Echo_var e;
  {
    CORBA::Object_var obj = orb->string_to_object(argv[1]);
    e = Echo::_narrow(obj);
    if (CORBA::is_nil(e)) {
      cerr << "Cannot invoke on a nil object reference." << endl;
      return 1;
    }
  }
  try {
    while (1) {
      CORBA::String_var src = (const char*) "Hello!";
      CORBA::String_var dest;
      dest = e->echoString(src);
      cerr << "I said,\"" << (char*)src << "\"."
	   << " The Object said,\"" << (char*)dest <<"\"" << endl;
      omni_thread::sleep(1);
    }
  }
  catch (...) {
    cerr << "Exception caught. Shutdown BOA" << endl;
  }
  myobj->_dispose();
  boa->impl_shutdown();
  return 0;
}

