CXXSRCS = client1.cc client2.cc client3.cc server.cc

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -I.. $(patsubst %,-I%/..,$(VPATH))

COMMON_OBJS = ../common/$(patsubst %,$(LibPattern),common)
ifdef ATMos
IMPORT_LIBRARY_DIRS += .
endif

CORBA_INTERFACES = echo

server   = $(patsubst %,$(BinPattern),server)
client1    = $(patsubst %,$(BinPattern),client1)
client2    = $(patsubst %,$(BinPattern),client2)
client3    = $(patsubst %,$(BinPattern),client3)

all:: $(server) $(client1) $(client2) $(client3)

clean::
	$(RM) $(server) $(client1) $(client2) $(client3)

$(server): server.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(client1): client1.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(client2): client2.o  $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(client3): client3.o  $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

