CXXSRCS = t_TypeSK.cc t_dynunion.cc t_dynany.cc t_dynenum.cc t_dynsequence.cc \
          t_dynarray.cc t_dynstruct.cc

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -I.. $(patsubst %,-I%/..,$(VPATH))

COMMON_OBJS = ../common/$(patsubst %,$(LibPattern),common)

t_dynany	= $(patsubst %,$(BinPattern),t_dynany)
t_dynenum	= $(patsubst %,$(BinPattern),t_dynenum)
t_dynsequence	= $(patsubst %,$(BinPattern),t_dynsequence)
t_dynarray	= $(patsubst %,$(BinPattern),t_dynarray)
t_dynstruct	= $(patsubst %,$(BinPattern),t_dynstruct)
t_dynunion	= $(patsubst %,$(BinPattern),t_dynunion)

all:: $(t_dynany) $(t_dynenum) $(t_dynsequence) $(t_dynarray) \
      $(t_dynstruct) $(t_dynunion)

clean::
	$(RM) $(t_dynany) $(t_dynenum) $(t_dynsequence) $(t_dynarray) \
              $(t_dynstruct) $(t_dynunion) 

$(t_dynany): t_dynany.o t_TypeSK.o $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_dynenum): t_dynenum.o t_TypeSK.o $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_dynsequence): t_dynsequence.o t_TypeSK.o $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_dynarray): t_dynarray.o t_TypeSK.o $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_dynstruct): t_dynstruct.o t_TypeSK.o $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_dynunion): t_dynunion.o t_TypeSK.o $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))


ifndef OMNIORB2_IDL_FPATH

t_TypeSK.cc : t_Type.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(OMNIORB2_IDL_ANY_FLAGS) $(notdir $^)

else

t_TypeSK.cc : t_Type.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL_FPATH) $(OMNIORB2_IDL_ANY_FLAGS) $(notdir $^)

endif
