// $Id: nameUtils.cc,v 1.2 1997/08/20 14:01:25 bjh Exp bjh $
// $Author: bjh $
//
// $Log: nameUtils.cc,v $
// Revision 1.2  1997/08/20  14:01:25  bjh
// Nicer syntax and getRootContext added.
//
// Revision 1.1  1997/08/18  15:27:24  bjh
// Initial revision
//

#include <assert.h>
#include <omniORB2/Naming.hh>
extern "C" {
#include <stdlib.h>
}
#include <iostream.h>
#include "nameUtils.h"

void
getNameFromEnv(const char *env_var, CosNaming::Name &name)
{  const char *value = getenv(env_var);
  if (value) {
    name = string_to_name((const char *)value);
  }
}

CosNaming::Name
string_to_name(const char *raw_name)
{
  CosNaming::Name name;
  // This is intended to provide a subset of the functionality of the
  // NamingStringSyntax module specified in version 1.5 of the
  // Interoperable Naming Service specification.  Maybe.

  // In practice, this means NameComponents are separated by forward
  // slashes and ids from kinds by dots.

  int raw_length = strlen(raw_name);
  int n = 0; // Number of NameComponents processed
  int last_break = -1; // The last separator/delimiter we spotted
  CORBA::Boolean seen_id = 0; // do we have an id yet?
  for (int p = 0; p <= raw_length; p++) {
    if (raw_name[p] == '.' || raw_name[p] == '/' || raw_name[p] == '\0') {
      int length = p - last_break - 1;
      CORBA::String_var component(CORBA::string_alloc(length+1));

      assert((raw_name+last_break+1) <= (raw_name+raw_length));

      memcpy((char *) component,
	     ((const char *) raw_name) + last_break + 1,
	     length);
      ((char *) component)[length] = '\0';
      last_break = p;
      if (raw_name[p] == '.') {
	name.length(n+1);
	name[n].id = component;
	  seen_id = 1;
      } else if ((raw_name[p] == '/' || raw_name[p] == '\0') && !seen_id) {
	name.length(n+1);
	name[n].id = component;
	name[n].kind = (const char *) "";
	n++;
      } else {
	name[n].kind = component;
	n++;
      }
    }
  }
  return name;
}

CORBA::Boolean
bindObjectToName(CORBA::ORB_ptr orb, CORBA::Object_ptr obj,
		 CosNaming::Name objName)
{
  CosNaming::NamingContext_var rootContext;
   try {
    // Find root context on name service:
    rootContext = getRootContext(orb);
  } catch (CORBA::ORB::InvalidName &ex) {
    cerr << "NameService does not exist." << endl;
    return 0;
  }

  try {
      rootContext->rebind(objName, obj);
  } catch (...) {
    cerr << "Failed to bind the object with the naming service." << endl;
    return 0;
  }
  return 1;
}

CosNaming::NamingContext_ptr getRootContext(CORBA::ORB_ptr orb)
{
  CosNaming::NamingContext_ptr rootContext;
  // Find root context on name service:
  CORBA::Object_var initServ;
  initServ = orb->resolve_initial_references("NameService");
  rootContext = CosNaming::NamingContext::_narrow(initServ);
  return rootContext;
}

CORBA::Object_ptr
getObjectReference(CORBA::ORB_ptr orb,CosNaming::Name& objName)
{
  CosNaming::NamingContext_var rootContext;
  
  try {
    rootContext = getRootContext(orb);
    CORBA::Object_ptr obj;
    // Resolve the name to an object reference, and assign the reference 
    // returned to a CORBA::Object:
    obj = rootContext->resolve(objName);
    return obj;
  }
  catch(CosNaming::NamingContext::NotFound& ex)
    {
      // This exception is thrown if any of the components of the
      // path [contexts or the object] aren't found:
      cerr << "Context not found." << endl;
      return CORBA::Object::_nil();
    }
  catch (...) {
    cerr << "Cannot resolve name to object." << endl;
    return CORBA::Object::_nil();
  }
}
