// Testing code: client of multiEcho objects
//
//   interface Echo {
//        string echoString(in string mesg);
//   };
//
//   interface DerivedEcho : Echo {
//        long echoLong (in long arg1);
//   };
//
//
//   interface moreEcho {
//         char echoChar(in char arg1);
//   };
//
//   interface multiEcho : DerivedEcho, moreEcho {
//         boolean echoBool(in boolean arg1);
//   };

#include <iostream.h>
#include <multiEcho.hh>
#include <common/common.h>

void
do_echolong_test(DerivedEcho_ptr e)
{
  CORBA::Long loopcount = 10;
  while (loopcount--) {
    CORBA::Long result;
    result = e->echoLong(loopcount);
    cerr << "reply " << result << endl;
    if (result != loopcount) {
      cerr << loopcount << " : echoLong differs (" << loopcount << ","
	   << result << ")" << endl;
      break;
    }
  }
}

void
do_echolong_test2(multiEcho_ptr e)
{
  CORBA::Long loopcount = 10;
  while (loopcount--) {
    CORBA::Long result;
    result = e->echoLong(loopcount);
    cerr << "reply " << result << endl;
    if (result != loopcount) {
      cerr << loopcount << " : echoLong differs (" << loopcount << ","
	   << result << ")" << endl;
      break;
    }
  }
}

void
do_echostring_test(Echo_ptr e)
{
  int loopcount = 10;
  while (loopcount--) {
    char * echostr;
    echostr = e->echoString((char *)"abcde");
    cerr << "reply " << echostr << endl;
    if (strcmp((const char *)echostr,"abcde")) {
      cerr << loopcount << " : echo string differs ('" << "abcde', '" 
	   << (char *)echostr << "')" << endl;
      break;
    }
    CORBA::string_free(echostr);
  }
}

void
do_echostring_test2(DerivedEcho_ptr e)
{
  int loopcount = 10;
  while (loopcount--) {
    char * echostr;
    echostr = e->echoString((char *)"abcde");
    cerr << "reply " << echostr << endl;
    if (strcmp((const char *)echostr,"abcde")) {
      cerr << loopcount << " : echo string differs ('" << "abcde', '" 
	   << (char *)echostr << "')" << endl;
      break;
    }
    CORBA::string_free(echostr);
  }
}

void
do_echochar_test(moreEcho_ptr e)
{
  CORBA::Long loopcount = 10;
  CORBA::Char v = 'a';
  while (loopcount--) {
    CORBA::Char result;
    CORBA::Char v;
    v = 'a' + loopcount % 52;
    result = e->echoChar(v);
    cerr << "reply " << result << endl;
    if (result != v) {
      cerr << loopcount << " : echoChar differs (" << v << ","
	   << result << ")" << endl;
      break;
    }
  }
}

void
do_echochar_test2(multiEcho_ptr e)
{
  CORBA::Long loopcount = 10;
  CORBA::Char v = 'a';
  while (loopcount--) {
    CORBA::Char result;
    CORBA::Char v;
    v = 'a' + loopcount % 52;
    result = e->echoChar(v);
    cerr << "reply " << result << endl;
    if (result != v) {
      cerr << loopcount << " : echoChar differs (" << v << ","
	   << result << ")" << endl;
      break;
    }
  }
}

void
do_echobool_test(multiEcho_ptr e)
{
  CORBA::Long loopcount = 10;
  while (loopcount--) {
    CORBA::Char result;
    CORBA::Boolean v = (loopcount % 1);
    result = e->echoBool(v);
    cerr << "reply " << (int)result << endl;
    if (result != v) {
      cerr << loopcount << " : echoBool differs (" << ((int)v) << ","
	   << (int)result << ")" << endl;
      break;
    }
  }
}


int
main (int argc, char **argv) {

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  
  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: multiEchoclt -i <stringified IOR>" << endl;
    cerr << "       multiEchoclt <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }

  try {
    cerr << "Try narrow to multiEcho interface...";
    multiEcho_ptr me = multiEcho::_narrow(obj);
    if (CORBA::is_nil(me))
      {
	cerr << "failed." << endl;
	cerr << "Try narrow to moreEcho interface...";
	moreEcho_ptr oe = moreEcho::_narrow(obj);
	if (CORBA::is_nil(oe))
	  {
	    cerr << "failed." << endl;
	    cerr << "Try narrow to DerivedEcho interface...";
	    DerivedEcho_ptr de = DerivedEcho::_narrow(obj);
	    if (CORBA::is_nil(de))
	      {
		cerr << "failed." << endl;
		cerr << "Try narrow to Echo interface...";
		Echo_ptr e = Echo::_narrow(obj);
		if (CORBA::is_nil(e))
		  {
		    cerr << "failed. Give up" << endl;
		    return 1;
		  }
		cerr << "succeeded." << endl;
		do_echostring_test(e);
		CORBA::release(e);
	      }
	    else
	      {
		cerr << "succeeded." << endl;
		do_echolong_test(de);
		do_echostring_test2(de);
		do_echostring_test(de);
		CORBA::release(de);
	      }
	  }
	else
	  {
	    cerr << "succeeded." << endl;
	    do_echochar_test(oe);
	    CORBA::release(oe);
	  }
      }
    else
      {
	cerr << "succeeded." << endl;
	do_echobool_test(me);
	do_echochar_test2(me);
	do_echochar_test(me);
	do_echostring_test2(me);
	do_echostring_test(me);
	do_echolong_test(me);
	do_echolong_test2(me);
      }
  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  return 0;
}
