// Testing code: client of attrObjRef objects
//
// interface attrObjRef {
//   attribute Object obj;
// };
//

// usage: attrObjRefclt -i <stringified IOR>
//        attrObjRefclt -i <stringified IOR> <new attribute: stringified IOR>
//        attrObjRefclt <attribute object name>
//        attrObjRefclt <attribute object name> <new attribute: read from this name>
//               Names are COSNaming compound names (e.g. x/y/test.obj
// 

#include <iostream.h>
#include <attrObjRef.hh>
#include <common/common.h>

char* x = "IOR:000000000000001349444c3a617474724f626a5265663a312e300001000000010000000000000028000100000000000d3139322e352e3233392e3631002089900000000c000000000000000000000009";

int
main (int argc, char **argv) {

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Boolean setobj = 0;
  attrObjRef_var e;
  CORBA::Object_var newvalue;

  switch (argc) {
  case 2:
  case 3:
  case 4:
    if (strcmp(argv[1],"-i") == 0) {
      if (argc > 2) {
	try {
	  CORBA::Object_var o = orb->string_to_object(argv[2]);
	  e = attrObjRef::_narrow(o);
	  if (argc > 3) {
	    newvalue = orb->string_to_object(argv[3]);
	    setobj = 1;
	  }
	  break;
	}
	catch (...) {
	  cerr << "Cannot convert stringified IOR to an object reference"
	       << endl;
	}
      }
    }
    else {
      try {
	CosNaming::Name attr_name = string_to_name(argv[1]);
	CORBA::Object_var o = getObjectReference(orb,attr_name);
	e = attrObjRef::_narrow(o);
	if (argc > 2) {
	  cerr << argv[2] << endl;
	  CosNaming::Name value_name = string_to_name(argv[2]);
	  newvalue = getObjectReference(orb,value_name);
	  setobj = 1;
	}
	break;
      }
      catch (...) {
	cerr << "Cannot resolve compound name to an object reference"
	     << endl;
      }
    }
  default:
    cerr << "usage: attrObjRefclt -i <stringified IOR>\n"
	 << "       attrObjRefclt -i <stringified IOR> <new attribute: stringified IOR>\n"
	 << "       attrObjRefclt <attribute object name>\n"
	 << "       attrObjRefclt <attribute object name> <new attribute: read from this name>\n"
	 << "       Names are COSNaming compound names (e.g. x/y/test.obj)"
	 << endl;
    return 1;
  }

  if (CORBA::is_nil(e))
    {
      cerr << "Can't create proxy for attribute object.\n" << endl;
      return(1);
    }

  try {
    if (setobj) {
      e->obj(newvalue);
    }

    CORBA::Object_var retvalue = e->obj();

    CORBA::String_var objstr;

    if (setobj) {
      if (!newvalue->_is_equivalent(retvalue))
	{
	  cerr << "Error: get attribute returns a different object reference." << endl;
	  objstr = orb->object_to_string(newvalue);
	  cerr << "       set value = '" << (char *)objstr << "'" << endl;
	  objstr = orb->object_to_string(retvalue);
	  cerr << "    return value = '" << (char *)objstr << "'" << endl;
	  return 1;
	}
    }
    objstr = orb->object_to_string(retvalue);
    cerr << "'" << (char*)objstr << "'" << endl;
  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  return 0;
}
