/*
 * Qstl.cc - test out the extensions in Q.h for C++.
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Qstl.cc,v 1.2 1998/02/28 23:16:09 pjm Exp $
 */

#include <stdio.h>

#include "check.h"

/* STL stuff */
#include <map.h>

struct lt {
  bool operator()(int a, int b) const {
    return a < b;
  }
};

/* Note: Q.h. Qstl.h MUST be included after map.h */
/* since they define S which is used as a template argument */

#include "../src/I.h"
#include "../src/Q.h"
#include "../src/Qstl.h"


main() {
  map<int,int,lt> ones;
  map<int,int,lt> ascending;
  map<int,int,lt> empty;

  for(int i = -10 ; i != 100; i++) {
    ones[i] = 1;
    ascending[i] = i;
  }

  CHECKMESSAGE("* Qstl.h tests");

  CHECKMESSAGE("** basic tests for each routine");

  CHECKTRUE(AO(i,ones,(*i).second == 1));
  CHECKTRUE(AO(i,empty,(*i).second == 10000));
  CHECKFALSE(AO(i,ones,(*i).second != 1));

  CHECKTRUE(EO(i,ascending,(*i).second == 99));
  CHECKFALSE(EO(i,ones,(*i).second == 100));
  CHECKFALSE(EO(i,empty,(*i).second == 1));

  CHECKTRUE(E1O(i,ascending,(*i).second == -10));
  CHECKTRUE(E1O(i,ascending,(*i).second > 98));
  CHECKFALSE(E1O(i,ascending,(*i).second > 97));
  CHECKFALSE(E1O(i,empty,true));
  
  CHECKTRUE(CO(i,ones,(*i).second == 66) == 0);
  CHECKTRUE(CO(i,ones,(*i).second == 1) == 110);
  CHECKTRUE(CO(i,empty,true) == 0);
  
  CHECKTRUE(SO(i,empty,(*i).second) == 0);
  CHECKTRUE(SO(i,ones,(*i).second) == 110);

  CHECKTRUE(PO(i,empty,(*i).second) == 1);
  CHECKTRUE(PO(i,ones,(*i).second) == 1);


  CHECKMESSAGE("** Test out the nested quantifiers");

#define T0 AO(i,ascending,E1O(j,ascending,(*j).second == (*i).second))
#define T1 AO(i,ascending,EO(j,ascending,(*j).second == (*i).second))
#define F0 AO(i,ascending,EO(j,ascending,(*j).second < (*i).second))
#define F1 AO(i,ascending,AO(j,ascending,(*j).second < (*i).second))

  CHECKTRUE(T0);
  CHECKTRUE(T1);
  CHECKFALSE(F0);
  CHECKFALSE(F1);

  CHECKTRUE(T0 && T1);
  CHECKFALSE(T0 && F0);
  CHECKTRUE(T1 || F0);
  CHECKTRUE(F0 || T1);
  CHECKFALSE(F0 && F1);
  CHECKFALSE(F0 || F1);


  CHECKTRUE(T0 && T1 && T0 && (!(F1)) && 1);
  CHECKTRUE(T0 && T1 && T0 && T0 && T1 && (T0|| F0));
  
  CHECKFALSE(F0 && T0);
  CHECKFALSE(T0 && F0);
  CHECKFALSE(T1 && 0);
  CHECKFALSE(!(F0) && F0);
  CHECKFALSE(F0? T0: 0 );
  CHECKFALSE(F0 && (!(T0)));
  CHECKFALSE(F0 || !(T1 && T0));
  CHECKFALSE(T1 && T0 && T1 && F0 && 1);
  CHECKFALSE(T1 && T1 && T0 && F0);

  return 0;
}
