/*
 * status.c - demo showing how we can display the state of a program using
 *    nana <==> TCL/TK.
 *
 *    nana - improved support for invariant checking and logging
 *    Copyright (C) 1996  P.J.Maker (pjm@cs.ntu.edu.au)
 * 
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License for more details.
 * 
 *    You should have received a copy of the GNU Library General Public
 *    License along with this library; if not, write to the Free
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /home/pjm/cvs/nana/tcl/status.c,v 1.2 1998/01/17 11:31:01 pjm Exp $ 
 */

#include <stdio.h>

#define L_DEFAULT_HANDLER fprintf
#define L_DEFAULT_PARAMS  status

#include <nana.h>

void send_file(FILE *, char*);

main() {
     FILE *status;
     int i, j;
     
     if((status = popen("/usr/local/bin/bltwish","w")) == NULL) {
	  fprintf(stderr, "can't start bltwish");
	  exit(1);
     }
     setbuf(status,NULL); /* unbuffered output */
     send_file(status,"status.tcl"); /* copy library code to interpreter */

     /* create two state variables for display */
     printf("logging azimuth, altitude and recording old values.\n");
     L("state azimuth\n"); 
     L("state altitude\n");

     /* and set them to various values */
     for(i = 0; i < 30; i += 10) {
	  for(j = 0; j <= 45; j +=45) {
	       L("state:set azimuth %d\n", i);
	       L("state:set altitude %d\n", j);
	       sleep(1);
	  }
     }

     printf("demonstrating logging to a text widget");
     /* TCLL - used to a text widget log */
#define TCLL(fmt, args...) L( "log:set message \"" fmt "\"\n", ##args)
     L("log message\n"); /* create the log */

     /* send off the messages */
     for(i = 0; i != 100; i++) {
	  TCLL("temperature = %d",  i );
	  TCLL("flow = %.1f",  ((float)i*i)/3.0 );
     }

     /* graphics demo (definitely a demo only!) */
     printf("and a graph\n");
     L("graph:new g\n");
     for(i = 0; i != 10; i++) {
       L("graph:add g %d %d\n", i* 10, (i % 2) * 10);
     }
     
     /* And finally tidy up */
     printf("type something to exit\n");
     getchar();
     fclose(status);
     return 0;
    
}

void send_file(FILE *fp, char *f) {
     FILE *in = fopen(f,"r");
     int c;
     
     if(in == NULL) {
	 abort();
     } 
     while((c = fgetc(in)) != EOF) {
	  fputc(c,fp);
     }
}

      
	  


