/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tfwrite.c,v $
 * Revision 6.1  96/11/24  00:36:07  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:35  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:38  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:54  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:59  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  94/02/16  14:34:36  raja
 * Use the CONST macro.
 * 
 * Revision 2.2  93/05/10  16:39:01  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * MB: added call to atkexit() 891012
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <portable.h>
#include <tstdio.h>

/*
 * external variables
 */
extern int _ioexit;
extern int errno;

/*
 * external functions
 */
extern void tfcloseall();
extern int iomap_write();

int
tfwrite(data, size, count, fp)
	CONST char *data;
	int size;
	int count;
	TFILE *fp;
{
	int n, m;
	int f;

	if (! _ioexit) {
		if (atkexit (tfcloseall, (char *) 0) != 0)
			return (-1);
		_ioexit = 1;
	}

	f = (fp->_flag |= _TIORW);
	n = count * size;
	if(f & _TIODEV)				/* device i/o */
	{
		for(m=0; m<n; ++m)
			if(tfputc(*data++, fp) == EOF)
				break;
	}
	else					/* file i/o */
	{
		tfflush(fp);			/* re-sync file pointers */
		m = iomap_write(f, fp->_file, data, n);
	}
	return((m > 0) ? (m / size) : (errno = m));
}
