/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	GDB
 *
 *	$Log:	rpdoom.c,v $
 * Revision 6.1  96/11/24  00:26:06  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:05:03  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:13:34  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:12  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:20  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.3  93/10/13  17:17:27  gdburns
 * Move ksigblock() before nsend() due to new kernel.
 * 
 * Revision 2.2.1.2  93/07/21  21:44:47  raja
 * Change to standard naming.
 * 
 *	Function:	- delivers a signal to a remote process
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *	Accepts:	- remote node
 *			- remote process selection method
 *			- remote process selection value
 *			- signal number
 *	Returns:	- 0 or ERROR
 */

#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;

/*
 * external functions
 */
extern int4		getrtype();	/* returns node type */

int
rpdoom(nodeid, sflags, svalue, signal)

int4			sflags;		/* process select flags */
int4			svalue;		/* process select value */
int4			nodeid;		/* target node address */
int4			signal;		/* signal number */

{
	struct nmsg	nhead;		/* network nhead */
	struct preq	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */
	int		mask;

	request.pq_sel_method = ltot(sflags);
	request.pq_sel_value = ltot(svalue);
	request.pq_src_node =
			((nodeid == LOCAL) || tiscast(getrtype(nodeid))) ?
			ltot(nodeid) : ltot(getnodeid());
	request.pq_src_event = ltot(- ((int4) getpid()));
	request.pq_signal = ltot(signal);
	request.pq_req = ltot(PQDOOM);

	nhead.nh_node = nodeid;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_length = sizeof(reply);
	nhead.nh_msg = (char *) &reply;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	if (reply.pr_reply) {
		errno = ttol(reply.pr_reply);
		return(ERROR);
	} else {
		return(0);
	}
}
