/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rget.c,v $
 * Revision 6.1  96/11/24  00:26:02  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:05:01  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/10  15:30:39  gdburns
 * Remove address from reply.
 * 
 * Revision 5.2  94/08/22  14:13:32  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:10  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:18  gdburns
 * Ohio Release
 * 
 *	Function:	- runtime access to the flat server
 *			- inquires about a given tag
 */

#include <stdlib.h>
#include <string.h>

#include <events.h>
#include <flatreq.h>
#include <ksignal.h>
#include <net.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;

/*
 * local functions
 */
static char		*do_get();

/*
 *	rget
 *
 *	Function:	- translates tag to address
 *	Accepts:	- server node ID
 *			- tag value
 *	Returns:	- corresponding tag address or ERROR
 */
char
*rget(nodeid, tag)

int4			nodeid;
int4			tag;

{
	return(do_get(nodeid, tag, (int4) FLQGET));
}

/*
 *	rforget
 *
 *	Function:	- translates tag to address
 *			- removes tag from server
 *	Accepts:	- server node ID
 *			- tag value
 *	Returns:	- corresponding tag address or ERROR
 */
char
*rforget(nodeid, tag)

int4			nodeid;
int4			tag;

{
	return(do_get(nodeid, tag, (int4) FLQFORGET));
}

/*
 *	do_get
 *
 *	Function:	- translates tag to address
 *	Accepts:	- server node ID
 *			- tag value
 *			- flatd request
 *	Returns:	- corresponding tag address or ERROR
 */
static char
*do_get(nodeid, tag, req)

int4			nodeid;
int4			tag;
int4			req;

{
	struct flreq	*request;	/* flatd request */
	struct flreply	*reply;		/* flatd reply */
	struct nmsg	nhead;		/* network message */
	int		mask;		/* signal mask */
	char		*p;		/* favourite ptr */
	char		fname[FLPATHLEN];
					/* tagged file name (OTB) */

	request = (struct flreq *) nhead.nh_data;
	reply = (struct flreply *) nhead.nh_data;

	request->flq_src_node = (nodeid == LOCAL) ? nodeid : getnodeid();
	request->flq_src_event = -getpid();
	request->flq_req = req;
	request->flq_tag = tag;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVFLATD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = 0;
	nhead.nh_length = 0;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(0);
	}

	nhead.nh_event = request->flq_src_event;
	nhead.nh_msg = fname;
	nhead.nh_length = FLPATHLEN;
	
	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(0);
	}

	ksigsetmask(mask);

	if (reply->flr_reply) {
		errno = reply->flr_reply;
		return(0);
	}
/*
 * The message body holds the name of a file from the remote daemon.
 * Allocate space for the filename, copy it and return a ptr to it.
 */
	p = malloc((unsigned) FLPATHLEN);
	if (p == 0) return(0);

	strcpy(p, nhead.nh_msg);
	return(p);
}
