/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	GDB
 *
 *	$Log:	rflclean.c,v $
 * Revision 6.1  96/11/24  00:26:00  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:05:00  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:13:31  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:09  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:17  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  93/10/13  17:17:20  gdburns
 * Move ksigblock() before nsend() due to new kernel.
 * 
 * Revision 2.2  93/05/04  16:45:59  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- removes tag and associated storage
 *	Accepts:	- remote node ID
 *			- tag value
 *	Returns:	- 0 or ERROR
 */

#include <events.h>
#include <flatreq.h>
#include <ksignal.h>
#include <net.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;

int
rflclean(nodeid, tag)

int4			nodeid;
int4			tag;

{
	struct flreq	*request;	/* flatd request */
	struct flreply	*reply;		/* flatd reply */
	struct nmsg	nhead;		/* network message */
	int		mask;		/* signal mask */

	request = (struct flreq *) nhead.nh_data;
	reply = (struct flreply *) nhead.nh_data;

	request->flq_src_node = (nodeid == LOCAL) ? nodeid : getnodeid();
	request->flq_src_event = -getpid();
	request->flq_req = FLQCLEAN;
	request->flq_tag = tag;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVFLATD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = 0;
	nhead.nh_length = 0;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = request->flq_src_event;
	
	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	if (reply->flr_reply) {
		errno = reply->flr_reply;
		return(ERROR);
	}

	return(0);
}
