/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log:	recho.c,v $
 * Revision 6.1  96/11/24  00:25:57  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:04:59  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:13:30  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:07  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:16  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.2  94/02/15  18:39:15  raja
 * Upgrade to use the CONST macro.
 * 
 * Revision 2.2.1.1  93/10/13  17:17:17  gdburns
 * Move ksigblock() before nsend() due to new kernel.
 * 
 * Revision 2.2  92/04/30  14:53:08  trillium
 * Ohio Release
 * 
 * Revision 2.1  91/03/20  11:38:35  gdburns
 * Ohio Release
 *
 *	Function:	- echoes a message to/from a remote node
 *	Accepts:	- remote node
 *			- outgoing message pointer
 *			- imcoming message pointer
 *			- outgoing message length
 *	Returns:	- incoming message length
 */

#include <ereq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <rreq.h>
#include <terror.h>
#include <typical.h>

int
recho(node, src_msg, dest_msg, length)

int4			node;			/* destination node */
CONST char		*src_msg;		/* ptr to source message */
char			*dest_msg;		/* echo message here */
int4			length;			/* length of echo message */

{
	struct nmsg	nhead;			/* message descriptor */
	struct ereq	*request;		/* echo request */
	int		mask;
/*
 * Check sanity on the length field.
 */
	if ((length < 0) || (length > MAXNMSGLEN)) {
		errno = EMSGLEN;
		return(ERROR);
	}
/*
 * Fill in echod request.
 */
	request = (struct ereq *) nhead.nh_data;
	request->eq_event = -getpid();
	request->eq_node = ((node == LOCAL) || (getrtype(node) & NT_CAST)) ?
			node : getnodeid();
	
	nhead.nh_node = node;
	nhead.nh_length = length;
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = (char *) src_msg;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
/*
 * Send request to the echo daemon.
 */
	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_msg = dest_msg;
	nhead.nh_length = length;
/*
 * Received echoed message.
 */
	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);
	return(nhead.nh_length);
}
