/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rbfparms.c,v $
 * Revision 6.1  96/11/24  00:25:50  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:04:56  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/16  01:53:02  gdburns
 * Remove user space buffer parameter.
 * 
 * Revision 5.2  94/08/22  14:13:26  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:02  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:11  gdburns
 * Ohio Release
 * 
 *	Function:	- controls buffer parameters
 */

#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
rbfparms(node, parms)

int4			node;
struct bfparms		*parms;

{
	struct nmsg	nhreq;		/* request message */
	struct nmsg	nhreply;	/* reply message */
	struct bfreq  	*request;	/* bufferd request */
	struct bfreply  *reply;		/* bufferd reply */
	int4		mask;		/* signal mask */

	request = (struct bfreq *) nhreq.nh_data;
	request->bfq_req = BFQSPACE;
	request->bfq_src_node = (node == LOCAL) ? node : getnodeid();
	request->bfq_src_event = -getpid();
	request->bfq_maxspace = parms->bfp_maxspace;

	nhreq.nh_node = node;
	nhreq.nh_event = EVBUFFERD;
	nhreq.nh_type = DLCTL;
	nhreq.nh_flags = NOBUF;
	nhreq.nh_length = 0;
	nhreq.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhreq)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = 0;
	nhreply.nh_msg = 0;

	if (nrecv(&nhreply)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	ksigsetmask(mask);

	reply = (struct bfreply *) nhreply.nh_data;

	if (reply->bfr_reply) {
		errno = reply->bfr_reply;
		return(LAMERROR);
	}

	return(0);
}
