/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	RBD/GDB
 *
 *	$Log:	tsend.c,v $
 * Revision 6.1  96/11/23  23:56:46  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:58:12  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/15  21:05:28  gdburns
 * Use updated portable.h.
 * 
 * Revision 5.2.1.1  96/01/15  20:52:18  gdburns
 * Use updated portable.h.
 * 
 * Revision 5.2  94/08/22  14:07:17  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:52:59  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:44:13  gdburns
 * Ohio Release
 * 
 *	Function:	- transport layer send
 */

#include <portable.h>
#include <typical.h>
#include <net.h>

int
tsend(nhead)

struct nmsg		*nhead;		/* network message descriptor */

{
	struct nmsg	sync;		/* synchronization message */
	int		save_event;	/* saved message event */
	int		ret;		/* returned value */
/*
 * Send the "ready to send" message.
 */
	sync.nh_node = nhead->nh_node;
	sync.nh_event = nhead->nh_event;
	sync.nh_type = nhead->nh_type;
	sync.nh_flags = DINT4DATA;
	sync.nh_length = 0;
	sync.nh_msg = (char *) 0;

	sync.nh_data[0] = getnodeid();
	sync.nh_data[1] = -getpid();

	if (nsend(&sync)) return(LAMERROR);
/*
 * Receive the "ready to receive" message.
 */
	sync.nh_event = -getpid();
	sync.nh_type = 0;

	if (nrecv(&sync)) return(LAMERROR);
/*
 * Send the data message using the event given by the receiver.
 */
	save_event = nhead->nh_event;
	nhead->nh_event = sync.nh_data[0];

	ret = nsend(nhead);

	nhead->nh_event = save_event;
	return(ret);
}
