/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	dsfr.c,v $
 * Revision 6.1  96/11/23  23:56:38  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:58:06  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.2  96/01/26  08:55:35  gdburns
 * Overhaul for TCP kernel.
 * 
 * Revision 5.2.1.1  94/10/20  12:10:02  gdburns
 * Split into front/back.
 * 
 * Revision 5.2  94/08/22  14:06:22  gdburns
 * Ohio Release
 *
 *	Function:	- sends, then receives a message at the
 *			  datalink sublayer (front/back)
 */

#include <net.h>

/*
 * local functions
 */
static void		dsfrsetup();

/*
 *	dsfr
 *
 *	Function:	- atomic datalink send and forward recv
 *			- full operation
 *	Accepts:	- ptr send pkt
 *			- ptr recv pkt
 *	Returns:	- 0 or ERROR
 */
int
dsfr(nhsend, nhrecv)

struct nmsg		*nhsend;
struct nmsg		*nhrecv;

{
	struct kmsg	khsend;		/* kernel send message */	
	struct kmsg	khrecv;		/* kernel receive message */	
	int		r;

	dsfrsetup(nhsend, nhrecv, &khsend, &khrecv);
	khrecv.k_msg = (char *) nhrecv;
	r = ksr(&khsend, &khrecv);
/*
 * In KPROBE, no data is transferred, not even the nmsg header, so
 * fill in the key fields from the kernel message descriptor.
 */
	if ((r == 0) && (khrecv.k_flags & KPROBE)) {
		nhrecv->nh_event = khrecv.k_event;
		nhrecv->nh_type = khrecv.k_type;
		nhrecv->nh_length = khrecv.k_length;
	}

	return(r);
}

/*
 *	dsfrfront
 *
 *	Function:	- sends message and initiates receive
 *	Accepts:	- ptr send packet
 *			- ptr receive packet
 *	Returns:	- receive file desc. or ERROR
 */
int
dsfrfront(nhsend, nhrecv)

struct nmsg		*nhsend;
struct nmsg		*nhrecv;

{
	struct kmsg	khsend;		/* send kernel msg */
	struct kmsg	khrecv;		/* recv kernel msg */

	dsfrsetup(nhsend, nhrecv, &khsend, &khrecv);
	return(ksrfront(&khsend, &khrecv));
}

/*
 *	dsfrback
 *
 *	Function:	- finishes receiving network pkt message
 *	Accepts:	- ptr receive packet
 *	Returns:	- 0 or ERROR
 */
int
dsfrback(nhrecv)

struct nmsg		*nhrecv;

{
	struct kmsg	khrecv;		/* kernel receive message */	
	int		r;

	khrecv.k_flags = KNMSG | nhrecv->nh_flags;
	khrecv.k_msg = (char *) nhrecv;

	r = ksrback(&khrecv);
/*
 * In KPROBE, no data is transferred, not even the nmsg header, so
 * fill in the key fields from the kernel message descriptor.
 */
	if ((r == 0) && (khrecv.k_flags & KPROBE)) {
		nhrecv->nh_event = khrecv.k_event;
		nhrecv->nh_type = khrecv.k_type;
		nhrecv->nh_length = khrecv.k_length;
	}

	return(r);
}

/*
 *	dsfrsetup
 *
 *	Function:	- setup prior to ksrfront() or ksr()
 *	Accepts:	- ptr send packet
 *			- ptr receive packet
 *			- ptr send kmsg
 *			- ptr receive kmsg
 */
static void
dsfrsetup(nhsend, nhrecv, khsend, khrecv)

struct nmsg		*nhsend;
struct nmsg		*nhrecv;
struct kmsg		*khsend;
struct kmsg		*khrecv;

{
/*
 * Set up the kernel message to send the network frame.
 */
	khsend->k_event = nhsend->nh_dl_event;
	khsend->k_length = nhsend->nh_length;
/*
 * Currently, dsfr() is never used to forward messages, since
 * the underlying ksr() only supports a local client/server interaction.
 * Thus we always code type and flags for final delivery.
 */
	khsend->k_type = nhsend->nh_type;
	khsend->k_flags = KNMSG | nhsend->nh_flags;
	khsend->k_msg = (char *) nhsend;
/*
 * Set up kernel message to receive the network frame.
 */     
	khrecv->k_event = nhrecv->nh_event;
	khrecv->k_type = nhrecv->nh_type;
	khrecv->k_length = nhrecv->nh_length;
	khrecv->k_flags = KNMSG | nhrecv->nh_flags;
}
