/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	RBD
 *
 *	$Log:	drecv.c,v $
 * Revision 6.1  96/11/23  23:56:35  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:58:04  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/16  12:46:29  gdburns
 * Set the length to the minimum length.
 * 
 * Revision 5.2  94/08/22  14:07:11  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:52:52  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:44:07  gdburns
 * Ohio Release
 * 
 *	Function:	- receives a message at the datalink sublayer
 *			- do not overwrite the header, only change the
 *			  nh_length and nh_type fields and the data pouch
 */

#include <string.h>

#include <net.h>
#include <typical.h>

int
drecv(nhead)

struct nmsg		*nhead;

{
	struct nmsg	incoming;	/* received network message header */
/*
 * Receive the message in a separate header.
 */
	memcpy((char *) &incoming, (char *) nhead, sizeof(struct nmsg));

	if (frecv(&incoming)) return(LAMERROR);
/*
 * Copy the received nh_type and nh_length fields and the data pouch.
 */
	nhead->nh_type = incoming.nh_type;
	nhead->nh_length = min(incoming.nh_length, nhead->nh_length);
	memcpy((char *) nhead->nh_data, (char *) incoming.nh_data,
			NHDSIZE * sizeof(int4));

	return(0);
}

/*
 *	dtry_recv
 *
 *	Function:	- non-blocking drecv()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
dtry_recv(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = drecv(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
