/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: tfree.c,v 6.1 96/11/23 22:54:36 nevin Rel $
 *
 *	Function:	- mark a datatype for deallocation
 *	Accepts:	- datatype (inout)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*
 * external functions
 */
extern int		lam_dtype_free();

int
MPI_Type_free(dtype)

MPI_Datatype		*dtype;

{
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPITFREE);
/*
 * Check the arguments.
 */
	if (dtype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (*dtype == MPI_DATATYPE_NULL || ((*dtype)->dt_flags & LAM_PREDEF)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITFREE, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
/*
 * If last reference really free the datatype otherwise just null the handle.
 */
	if (--((*dtype)->dt_refcount) == 0) {

		err = lam_type_free(*dtype);
		*dtype = MPI_DATATYPE_NULL;

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(MPI_COMM_WORLD,
						BLKMPITFREE, err));
		}
	} else {
		*dtype = MPI_DATATYPE_NULL;
	}

	lam_resetfunc(BLKMPITFREE);
	return(MPI_SUCCESS);
}
