/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: test.c,v 6.1 96/11/23 22:54:27 nevin Rel $
 *
 *	Function:	- test if request is done
 *	Accepts:	- request
 *			- flag (returned)
 *			- status (returned)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		lam_errfunc();
extern int		lam_test();


int
MPI_Test(req, flag, stat)

MPI_Request		*req;
int			*flag;
MPI_Status		*stat;

{
	int		err;
	MPI_Comm	comm;
	
	lam_initerr();
	lam_setfunc(BLKMPITEST);

	comm = (req && *req) ? (*req)->rq_comm : MPI_COMM_WORLD;
	
	err = lam_test(req, 1, flag, stat);

	lam_resetfunc(BLKMPITEST);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPITEST, err));
	}

	return(MPI_SUCCESS);
}
