/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: start.c,v 6.1 96/11/23 22:54:20 nevin Rel $
 *
 *	Function:	- start communication request
 *	Accepts:	- ptr to request
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern int		lam_errfunc();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();


int
MPI_Start(req)

MPI_Request		*req;

{
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPISTART);

	if (req == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPISTART, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (*req == MPI_REQUEST_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPISTART, lam_mkerr(MPI_ERR_REQUEST, 0)));
	}

	err = MPI_Startall(1, req);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc((*req)->rq_comm, BLKMPISTART, err));
	}

	lam_resetfunc(BLKMPISTART);
	return(MPI_SUCCESS);
}
