/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: ssend.c,v 6.1 96/11/23 22:54:17 nevin Rel $
 *
 *	Function:	- synchronous send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Ssend(buf, count, dtype, dest, tag, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;

{
	int		err;

	lam_initerr();
	lam_setfunc(BLKMPISSEND);

	err = lam_send(buf, count, dtype, dest, tag, comm, LAM_RQISSEND);

	lam_resetfunc(BLKMPISSEND);

	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPISSEND, err));

	return(MPI_SUCCESS);
}
